clear all

t0  = 0;     %initial time
t1  = 100;    % final time
x0  = 10;     % initial biomass population
y0  = 46;    % initial glucose concentration
z0 = 0.65;   %initial ammonium concentration
%
% initial state for use in DE solver.
%
S0  = [x0;y0;z0];

%
% rate constants and problem parameters
%  Inf values were recorded from lectures, found by converting rediduals mmol to g
yInf = 15.33;
zInf = 0.0034;
xInf = 1.227;
q   = 0.03;
K   = 30;
E   = 14.3;
u   = 25;
L   = 2;
v   = 5;
r   = q*(yInf+K)*(zInf+L)/(yInf*zInf);
F   = (q*zInf-q*v)/(xInf*q);
%
% rate constants into parameter vector
%
params(1) = q;
params(2) = u;
params(3) = r;
params(4) = K;
params(5) = E;
params(6) = F;
params(7) = L;
params(8) = v;
%
% define function for fixed parameter values
%
chemostat_2nutrient_dynamics_params = @(t,S)chemostat_2nutrient_dynamics(t,S,params);

%
% call the matlab function to solve the DE for us.
%
[t,St] = ode45(chemostat_2nutrient_dynamics_params,[t0 t1],S0);
%
% Plot the results.
%
plot(t,St,'LineWidth',3)

legend('biomass','glucose','ammonium')
xlabel('time')
ylabel('states')
