function [Params1 Params2]=FACSTimecourse(filenames, col, Gates,Output)
%%
%%%
% SUMMARY:
% This function takes a filename of a .fcs file OR the data from the .fcs
% file (see below), lets the user select a gate from a plot of the
% side-scatter vs the forward scatter and returns the indices of the data
% points in the fcs data that are within this gate.
%
% INPUTS:
%   filenameORdata: This is either the name of a .fcs file to open, or the actual fcs FACS data 
%   (ie fcsdat from the call to  [fcsdat, fcshdr] = fca_readfcs(filename))
%
%   col-column of data from the .fcs file that we are interested in (first
%   two columns for our machine are forward and side scatter, after that
%   the columns are the fluorescence intensity information for different
%   channels
%
%   Gates-indices of points to include (based on forward and side scatter)
%   returned by FindGate
%  
%   varargin:
%   varargin{1}: 0 if output is to be suppressed (default), 1 if output
%   (ie, plot of the gate and the stuff in the gate) IS to be plotted
%   varargin{2}: name for the title of the plot when data is sent in rather
%   than a filename
%   
%
% OUTPUTS:
%   Params1: Parameters (mean and standard deviation) for a single gaussian
%   fit
%
%   Params2: Parameters (proportion, mean 1, mean 2, standard deviation 1,
%   standard deviation 2) for a fit to two gaussian distributions
%   
%    
% REQUIRES:
%   fca_readfcs
%   FitNorms
%
% REFERENCES:
% Mathworks documentation on inpolygon:
%    http://www.mathworks.com/help/techdoc/ref/inpolygon.html
%
%    Written by Megan McClean, Ph.D.
%               Lewis-Sigler Institute for Integrative Genomics
%               Princeton University
%               120 Carl Icahn
%               Princeton, NJ 08544
%               mmcclean@princeton.edu
%
%    Last revised on February 22, 2012


%%
%%
if ~iscell(filenames)
    files=dir(filenames);
else
    files=struct('name',[]);    
    for i=1:length(filenames)
        files(i).name=filenames{i};
    end
end

%Variables to hold the parameters from the fits (means and standard
%deviations)
Params1=[];
Params2=[];

for i=1:length(files)
  [fcsdat, fcshdr] = fca_readfcs(files(i).name);
  [P2 P1]=FitNorms(fcsdat(Gates{i},col),Output);
  Params1=[Params1; P1];
  Params2=[Params2; P2];

end
 
