%script to fit mystery circuits
clear all
close all

%bbA
bbA = dlmread('bbA.dat', '\t'); %load data
freq = bbA(:,1);
output = bbA(:,2);
outputNorm = output./max(output); %normalize
Fit = lsqcurvefit(@hpfilter, [10e-6 100], freq, outputNorm);
capFitA = Fit(1); resFitA = Fit(2);
f_0A=1/(capFitA*resFitA)
outputFitA = hpfilter([capFitA, resFitA], freq);
subplot(2,2,1)
loglog(freq, outputNorm, 'bo', freq, outputFitA, 'k-');
title('box A (high-pass)')
xlabel('freq (Hz)')
ylabel('transfer function')

%bbB
bbB = dlmread('bbB.dat', '\t'); %load data
freq = bbB(:,1);
output = bbB(:,2);
outputNorm = output./max(output); %normalize
Fit = lsqcurvefit(@lp_lpfilter, [10e-5, 100, 10e-5, 100], freq, outputNorm);
cap1FitB = Fit(1); res1FitB = Fit(2); cap2FitB = Fit(3); res2FitB = Fit(4);
f_0B1=1/(cap1FitB*res1FitB)
f_0B2=1/(cap2FitB*res2FitB)
outputFitB = lp_lpfilter([cap1FitB, res1FitB, cap2FitB, res2FitB], freq);
subplot(2,2,2)
loglog(freq, outputNorm, 'bo', freq, outputFitB, 'k-');
title('box B (double-pole low-pass)')
xlabel('freq (Hz)')
ylabel('transfer function')

%bbC
bbC = dlmread('bbC.dat', '\t'); %load data
freq = bbC(:,1);
output = bbC(:,2);
outputNorm = output./max(output); %normalize
Fit = lsqcurvefit(@lpfilter, [10e-6 100], freq, outputNorm);
capFitC = Fit(1); resFitC = Fit(2);
f_0C=1/(capFitC*resFitC)
outputFitC = lpfilter([capFitC, resFitC], freq);
subplot(2,2,3)
loglog(freq, outputNorm, 'bo', freq, outputFitC, 'k-');
title('box C (low-pass)')
xlabel('freq (Hz)')
ylabel('transfer function')

%bbD
bbD = dlmread('bbD.dat', '\t'); %load data
freq = bbD(:,1);
output = bbD(:,2);
outputNorm = output./max(output); %normalize
Fit = lsqcurvefit(@bpfilter, [10e-6, 100, 10e-6, 100], freq, outputNorm);
cap1FitD = Fit(1); res1FitD = Fit(2); cap2FitD = Fit(3); res2FitD = Fit(4);
f_0D1=1/(cap1FitD*res1FitD)
f_0D2=1/(cap2FitD*res2FitD)
outputFitD = bpfilter([cap1FitD, res1FitD, cap2FitD, res2FitD], freq);
subplot(2,2,4)
loglog(freq, outputNorm, 'bo', freq, outputFitD, 'k-');
title('box D (band-pass)')
xlabel('freq (Hz)')
ylabel('transfer function')