clear all, close all
info = aviinfo('beadtest.avi');

for k=1:info.NumFrames
    mov=aviread('beadtest.avi',k);
    frame=mov.cdata;
    A=double(frame(154:206, 425:488,1));

    Threshold = 0;
    ThresholdMtx = Threshold .* ones(size(A,1), size(A,2));
    BinaryMtx = ( A > ThresholdMtx );
    LabeledA = BinaryMtx.*A;  
    
    xsum = 0; ysum = 0;
    for p = 1: size(A,1)  % row: y-coordinate
        for q = 1: size(A,2)  % column: x-cooridinate
            xsum = xsum + q*LabeledA(p,q);
            ysum = ysum + p*LabeledA(p,q);    
        end
    end
    xc = xsum/sum(sum(LabeledA));
    yc = ysum/sum(sum(LabeledA));

    BeadPos(:,k) = [xc; yc];
end

y = [BeadPos(1,1:info.NumFrames) ; BeadPos(2,1:info.NumFrames)];
fid = fopen('BeadPos.txt','w');
fprintf(fid,'%6.4f \t %6.4f \n',y);
fclose(fid)
'Position of the Bead is saved in BeadPos.txt'

figure(1)
plot(BeadPos(1,1:info.NumFrames)*0.14,BeadPos(2,1:info.NumFrames)*0.14,'o-')
title('Bead Position using Centroid Method')
xlabel('\mum'); ylabel('\mum');        
