% 4. Segmentation.

% First choose an appropriate threshold value.

clear all, close all

M = 1; N = 2;
A = imread('actin_f.tif');
figure(1)
subplot(M,N,1), imshow(A); title('actin fiber')

%tf = graythresh(A);  % Finds the optimal threshold using Otsu's method
tf = 80/255;
subplot(M,N,2), imshow(im2bw(A,tf)); title('Segmentation with threshold 80/255');

figure(2)
B = imread('actin_treated.tif');
subplot(M,N,1), imshow(B); title('CytoD treated actin fiber')

%tt = graythresh(B);
tt = 80/255;
subplot(M,N,2), imshow(im2bw(B,tt)); title('Segmentation with threshold 80/255');

% Bonus, quantitative metric to quanitfy the degree of fiber-ness of the
% cytoskeleton

% Edge detection
figure(3)
edge_A = edge(A, 'prewitt');
subplot(M,N,1), imshow(edge_A)
edge_B = edge(B, 'roberts');
subplot(M,N,2), imshow(edge_B);

% Laplacian edge detection
figure(4)
log = fspecial('log',13,2);
edge_A_L = edge(A, 'zerocross',log); 
subplot(M,N,1), imshow(edge_A_L), title('Laplacian edge detection')
edge_B_L = edge(B, 'zerocross',log);
subplot(M,N,2), imshow(edge_B_L)


% Most powerful edge detection algorithm : Canny
figure(5)
edge_A_C = edge(A, 'canny');
subplot(M,N,1), imshow(edge_A_C), title('Canny edge detection')
edge_B_C = edge(B, 'canny');
subplot(M,N,2), imshow(edge_B_C)
pixval on