% Periodic noise filtering 
close all
M = 2; N = 2;

% A = imread('low_noise.tif');
% B = imread('high_noise.tif');
% C = imread('noise.tif');


A = lownoise;
B = newnoise;  % highnoise
C = noise;
D = imread('ecoli_noisy.jpg');

figure(1)
subplot(M, N, 1), imshow(A);  title('Low noise')
Af = fftshift(fft2(A));
subplot(M, N, 2), fftshow(Af,'log'), title('FFT of low noise')

fAf = ones(size(A,1),size(A,2));
%tBf = 
% pixval on
% Notch filtering


rblock1 = 55  ; cblock1 = 61;
rblock2 = 75  ; cblock2 = 70;
% % Notch filtering
Df = 1;
fAf(rblock1-Df:rblock1+Df,cblock1-Df:cblock1+Df) = 0;
fAf(rblock2-Df:rblock2+Df,cblock2-Df:cblock2+Df) = 0;
fAf(:, cblock1-Df:cblock1+Df) = 0;
fAf(:, cblock2-Df:cblock2+Df) = 0;
fAf(rblock1-Df:rblock1+Df, :) = 0;
fAf(rblock2-Df:rblock2+Df, :) = 0;

tAf = Af.*fAf;
subplot(M,N,3), fftshow(tAf,'log'), title('Notch filtered FFT')

IAf = abs(ifft2(tAf));
IAf = uint8(255*mat2gray(IAf));
subplot(M, N, 4), imshow(IAf), title('Invere FFT')
%impixelinfo;
pixval on


figure(2)
subplot(M, N, 1), imshow(B); title('High noise')
Bf = fftshift(fft2(B));
subplot(M, N, 2), fftshow(Bf,'log'), title('FFT of high noise')
fBf = ones(size(B,1),size(B,2));
%tBf = 
pixval on

% % Notch filtering
fBf(:, 49:51) = 0;
fBf(:, 78:80) = 0;
fBf(57:59, :) = 0;
fBf(69:71, :) = 0;

rblock1 = 58  ; cblock1 = 50;
rblock2 = 70  ; cblock2 = 79;
Df = 3;
fBf(rblock1-Df:rblock1+Df,cblock1-Df:cblock1+Df) = 0;
fBf(rblock2-Df:rblock2+Df,cblock2-Df:cblock2+Df) = 0;

tBf = Bf.*fBf;
subplot(M,N,3), fftshow(tBf,'log'), title('Notch filtered FFT')

ItBf = abs(ifft2(tBf));
ItBf = uint8(255*mat2gray(ItBf));
subplot(M, N, 4), imshow(ItBf), title('Invere FFT')


figure(3)
subplot(M, N, 1), imshow(C); title('Noise')
Cf = fftshift(fft2(C));
subplot(M, N, 2), fftshow(Cf,'log'), title('FFT of Noise')
ICf = abs(ifft2(Cf));
ICf = uint8(255*mat2gray(ICf));
%subplot(M, N, 3), imshow(ICf), title('Invere FFT')

pixval on

figure(4)
subplot(M, N, 1), imshow(D); title('Noisy Ecoli')
Df = fftshift(fft2(D));
subplot(M, N, 2), fftshow(Df,'log'), title('FFT ')
fDf = ones(size(D,1),size(D,2));

pixval on   

% Notch filtering
fDf(:, 138:250) = 0;
fDf(:, 1:115) = 0;
fDf(126,1:125) = 0; fDf(126,127:250) = 0; 
rblock1 = 118 ; cblock1 = 139;
rblock2 = 133  ; cblock2 = 113;
D = 1;
fDf(rblock1-D:rblock1+D,cblock1-D:cblock1+D) = 0;
fDf(rblock2-D:rblock2+D,cblock2-D:cblock2+D) = 0;


%fDf(120:130,120:130) = 0;  % high pass filtering 

tDf = Df.*fDf;
subplot(M,N,3), fftshow(tDf,'log'), title('Notch filtered FFT')

ItDf = abs(ifft2(tDf));
ItDf = uint8(255*mat2gray(ItDf));
subplot(M, N, 4), imshow(ItDf), title('Invere FFT')
