% median filter
M = 2; N = 3;

A = imread('spiky_actin1.tif');
B = imread('spiky_actin2.tif');
fA = medfilt2(A,[3 3]);
lp = fspecial('average',[3,3]);
lpA = uint8(filter2(lp, A));
Avg = (double(A)+double(B))/2;
Avg = uint8(Avg);

figure(1)
subplot(M,N,1), imshow(A), title('Spiky actin 1')
subplot(M,N,2), imshow(fA), title('Median Filtered')
subplot(M,N,3), imshow(lpA), title('Low Pass filtered')
subplot(M,N,4), imshow(B), title('Spiky actin 2')
subplot(M,N,5), imshow(Avg), title('Average of actin 1 & 2')

for i = 1: size(A,1)
    for j = 1:size(A,2)
        if (A(i,j) > B(i, j))
            C(i,j) = B(i, j);
        else
            C(i,j) = A(i,j);    
        end
        
    end
end
subplot(M,N,6), imshow(C), title('Comparing pixels between two image')
figure(2)
fC = medfilt2(C,[3 3]);
subplot(M,N,1), imshow(fC), title('Comparing pixels between two image with Median filter')
