function [ dSdt ] = chemostat_dynamics(t,S,params)
% this function defines the chemostat differential equation
%
% rate constants and problem parameters
%
r   = 2;
K   = 15;
ep  = 1.1;
u   = 6;
q   = 0.15;
%
% initialize the state's derivative
%
dSdt = zeros(size(S));
%
% put things in terms of individual variables
%
x = S(1); % cells
y = S(2); % food
%
% form the differential equation formulae
%
ry    = r*y/(K+y);
dxdt  = (ry)*x - q*x;
dydt  = q*(u - y) - ep*ry*x;
%
% put things back in terms of state vector variable
%
dSdt(1) = dxdt;
dSdt(2) = dydt;
end