function [ dSdt ] = chemostat_dynamics(t,S,params)
% this function defines the chemostat differential equation
%
% get the individual parameters from the vector
%
q    = params(1);
u    = params(2);
r    = params(3);
K    = params(4);
ep   = params(5);
%
% initialize the state's derivative
%
dSdt = zeros(size(S));
%
% put things in terms of individual variables
%
x = S(1); % cells
y = S(2); % food
%
% form the differential equation formulae
%
ry    = r*y/(K+y);
dxdt  = (ry)*x - q*x;
dydt  = q*(u - y) - ep*ry*x;
%
% put things back in terms of state vector variable
%
dSdt(1) = dxdt;
dSdt(2) = dydt;
end