clear all

t0  = 0;     %initial time
t1  = 100;    % final time
x0  = 3;     % initial cell population
y0  = 0;    % initial glut concentration
z0  = 0;    % initial ammonium conc
%
% initial state for use in DE solver.
%
S0  = [x0;y0;z0];
%
% rate constants and problem parameters
%
taiParams;

iCase = 2;

ep = E(iCase);
fp = F(iCase);
u  = uu(iCase);
v  = vv(iCase);

SData = [bioMass(iCase);rG(iCase);rA(iCase)]

%
% rate constants into parameter vector
%
params = zeros(8,1);

params(1) = q;
params(2) = u;
params(3) = v;
params(4) = ep;
params(5) = fp;
params(6) = r;
params(7) = K;
params(8) = L;
%
% define function for fixed parameter values
%
chemostat_2nutrient_dynamics_params = @(t,S)chemostat_2nutrient_dynamics(t,S,params);

%
% call the matlab function to solve the DE for us.
%
[t,St] = ode45(chemostat_2nutrient_dynamics_params,[t0 t1],S0);


figure

plot(t,St,'LineWidth',3)

legend('cells','glucose','ammo')
xlabel('time')
ylabel('states')
title(experimentCase(iCase))
hold on
plot([100;100;100],SData,'ko','LineWidth',3)
hold off






