clear all

t0  = 0;     %initial time
t1  = 100;    % final time
x0  = 3;     % initial cell population
y0  = 0;    % initial glut concentration
z0  = 0;
%
% initial state for use in DE solver.
%
S0  = [x0;y0;z0];
%
% rate constants and problem parameters
%
taiParams;

thetaStash = zeros(3,4);
modelStash = zeros(3,4);
SSEStash   = zeros(1,4);

for iCase = 1:4
    
    ep = E(iCase);
    fp = F(iCase);
    u  = uu(iCase);
    v  = vv(iCase);
    
    SData = [bioMass(iCase);rG(iCase);rA(iCase)]
    % % r   = 0.221; %0.46
    % % K   = 0.1; %0.0096; %0.8;
    % % L   = 0.212; %15.91;
    % % ep  = 1/0.07;
    % % fp  = 2.23;
    % % u   = 25;
    % % v   =  5;
    % % q   = 0.03;
    
    %
    % rate constants into parameter vector
    %
    params = zeros(8,1);
    
    params(1) = q;
    params(2) = u;
    params(3) = v;
    params(4) = ep;
    params(5) = fp;
    params(6) = r;
    params(7) = K;
    params(8) = L;
    
    paramsFixed = params(1:5);
    theta0      = params(6:8);
    
    chemostat_fit_params = @(theta)chemostat_equilib_fit(theta,paramsFixed,t0,t1,S0,SData);
    
    theta1 = fmincon(chemostat_fit_params,theta0,[],[],[],[],1e-4*ones(size(theta0)),[3;20;5]);
    
    paramsOpt = [paramsFixed;theta1];
    
    chemostat_2nutrient_dynamics_opt = @(t,S)chemostat_2nutrient_dynamics(t,S,paramsOpt);
    
    %
    % call the matlab function to solve the DE for us.
    %
    [t,St] = ode45(chemostat_2nutrient_dynamics_opt,[t0 t1],S0);
    %
    % Plot the results.
    %
    figure
    plot(t,St,'LineWidth',3)
    
    legend('cells','glucose','ammo')
    xlabel('time')
    ylabel('states')
    title(experimentCase(iCase)) 
    
    hold on
    plot([100;100;100],SData,'ko','LineWidth',3)
    hold off
    
    thetaStash(:,iCase) = theta1;
    modelStash(:,iCase) = St(end,:);
    SSEStash(iCase) = chemostat_fit_params(theta1);
    
    title([experimentCase(iCase),' ,SSE = ',num2str(SSEStash(iCase))]); 

end




