library(ggplot2)

theme_set(theme_bw(base_size=10))
old_theme <- theme_update(panel.border=element_blank(),
                          panel.grid.minor=element_blank(),
                          panel.grid.major=element_blank(),
                          panel.background=element_blank(),
                          panel.border=element_blank(),
                          axis.line=element_line(color="black"),
                          legend.position="none",
                          axis.title.x=element_text(vjust=-0.5))

f_tilde <- function(X0, k, tau, sum_H, C1){
  ret <- (X0 - k)*k*tau/(X0*tau - k*tau + sum_H)
  ret <- ret - k*log(k/(X0*tau - k*tau + sum_H))
  ret <- ret + k*sum_H/(X0*tau - k*tau + sum_H)
  ret <- ret - C1 - lgamma(X0 + 1) + lgamma(X0 - k + 1)
  ret
}

kval <- 8
x_up <- 50
tau_val <- 1
C1_val <- 1
an_f <- function(X0, sum_H){
  f_tilde(C1=C1_val, k=kval, tau=tau_val, X0=X0, sum_H=sum_H)
}

an_f_asy <- -C1_val + kval - kval * log(kval) + kval * log(tau_val)

c1 <- sum(1/seq_len(kval))
c2 <- (kval + 1) / 2

sum_H <- c1
plot_f <- function(x) an_f(x, sum_H=c1)

lsz <- 0.5
g <- ggplot(data.frame(x=c(kval, x_up)), aes(x))
g <- g + stat_function(fun=function(x) an_f(x, sum_H=c1), geom="line", aes(colour="case1"), size=lsz)
g <- g + stat_function(fun=function(x) an_f(x, sum_H=c1 * 0.9), geom="line", aes(colour="case1"), size=lsz)
g <- g + stat_function(fun=function(x) an_f(x, sum_H=c1 - (c1 - c2)/ 2), geom="line", aes(colour="case2"), size=lsz)
g <- g + stat_function(fun=function(x) an_f(x, sum_H=c1 - (c1 - c2)/ 4), geom="line", aes(colour="case2"), size=lsz)
g <- g + stat_function(fun=function(x) an_f(x, sum_H=c1 - 3 * (c1 - c2)/ 4), geom="line", aes(colour="case2"), size=lsz)
g <- g + stat_function(fun=function(x) an_f(x, sum_H=c2), geom="line", aes(colour="case3"), size=lsz)
g <- g + stat_function(fun=function(x) an_f(x, sum_H=c2 * 1.1), geom="line", aes(colour="case3"), size=lsz)
g <- g + geom_segment(aes(y=an_f_asy, yend=an_f_asy, x=kval, xend=x_up), size=lsz)
g <- g + scale_colour_manual(values = c("case1"="#332288", "case2"="#999933", "case3" = "#AA4499"))
g <- g + xlab("Initial susceptibles") + ylab("Negative log likelihood")

ggsave(file="f-vs-X0.eps", width=4, height=4, pointsize=10)
