library(ggplot2)
library(reshape)
library(plyr)

load("simStudy-post.RData")

sub1 <- res_df_tr[res_df_tr$propFreeImp==0 & res_df_tr$propOnsetNA==0, ]
sub1 <- sub1[sub1$floor_times == FALSE, ]

sub2 <- sub1[sub1$hat_ctr > 0.0001, ]
#sub2 <- sub2[sub2$hat_cgr < 10, ]

m <- melt.data.frame(sub2, id="nreps", measure.vars=c("hat_ctr", "hat_cgr"))
m <- m[!is.na(m$value), ]

tab1 <- res_tab_tr
tab1 <- tab1[tab1$propFreeImp==0 & tab1$propOnsetNA==0 & tab1$floor_times==FALSE, ]

tab1$hat_ctr <- with(tab1, bias_tr + tr)
tab1$hat_cgr <- with(tab1, bias_gr + gr)
m2 <- melt.data.frame(tab1, id="nreps",
                      measure=c("hat_ctr", "hat_cgr"))

## Get data frame with true values
v <- sub1[1, c("tr", "gr")]
v <- t(v)
v <- as.data.frame(v)
v$variable <- rownames(v)
v$variable <- gsub("tr", "hat_ctr", v$variable)
v$variable <- gsub("gr", "hat_cgr", v$variable)
names(v)[1] <- "value"

## Now for infectious period
sub3 <- res_df_ip[res_df_ip$propFreeImp==0 & res_df_ip$propOnsetNA==0, ]
sub3 <- sub3[sub3$floor_times == FALSE, ]

n <- melt.data.frame(sub3, id="nreps",
                      measure.vars=c("hat_scale", "ip_dispersion_hat"))
n <- n[!is.na(n$value), ]

tab2 <- res_tab_ip
tab2 <- tab2[tab2$propFreeImp==0 & tab2$floor_times==FALSE, ]

tab2$hat_scale <- with(tab2, bias + ip)
tab2$ip_dispersion_hat <- with(tab2, bias_disp + ip_dispersion)
n2 <- melt.data.frame(tab2, id="nreps",
                      measure=c("hat_scale", "ip_dispersion_hat"))

## Get data frame with true values
v2 <- sub3[1, c("ip", "ip_dispersion")]
v2 <- t(v2)
v2 <- as.data.frame(v2)
v2$variable <- rownames(v2)
v2$variable <- gsub("^ip_dispersion$", "ip_dispersion_hat", v2$variable)
v2$variable <- gsub("^ip$", "hat_scale", v2$variable)
names(v2)[1] <- "value"

ests <- rbind(m, n)
estsMeans <- rbind(m2, n2)
V <- rbind(v, v2)

makeflabs <- function(x) {
  factor(x,
         levels=c("hat_ctr", "hat_cgr", "hat_scale", "ip_dispersion_hat"),
         labels=c("Transmission\nrate", "Initial\ngrowth\nrate",
           "Symptomatic\nperiod\nmean", "Symptomatic\nperiod\ndispersion"))
}

V$flabs <- makeflabs(V$variable)
ests$flabs <- makeflabs(ests$variable)
estsMeans$flabs <- makeflabs(estsMeans$variable)

g <- ggplot(data=ests, aes(x=as.factor(nreps), y=value))
g <- g + geom_jitter(position=position_jitter(width=0.3), size=0.3)
g <- g + geom_point(data=estsMeans, aes(x=as.factor(nreps), y=value),
                    colour="black", size=6)
g <- g + geom_point(data=estsMeans, aes(x=as.factor(nreps), y=value),
                    colour="grey", size=5)

get_breaks <- function(x)
{
  lo <- floor(log10(min(x, na.rm = TRUE)))
  hi <- ceiling(log10(max(x, na.rm = TRUE)))
  as.vector(10 ^ (lo:hi) %o% 10^c(0, 0.5))
}
breaks <- get_breaks(m$value)
log10_breaks <- log10(breaks)
fmt_func <- function(x) {
  formatC(x, format="f", digits=8, drop0trailing=T)
}
the_labels <- ifelse(log10_breaks == floor(log10_breaks), fmt_func(breaks), " ")
g <- g +  scale_y_log10(breaks = breaks, labels = the_labels)
breaks <- unique(m$nreps) 
#g <- g +  scale_x_log10(breaks = breaks, labels=breaks)
g <- g + theme_bw(base_size=12)
g <- g + facet_grid(flabs~., scales='free_y')
g <- g + theme(
       strip.text.x=element_blank(),
       #strip.text.y=element_blank(),
       strip.background=element_blank(),
       legend.position="none",
       plot.background = element_blank(),
       panel.grid.major = element_blank(),
       panel.grid.minor = element_blank(),
       panel.border = element_blank(),
       panel.background = element_blank())
g <- g + theme(axis.line = element_line(color = 'black'))
g <- g + geom_hline(data=V, aes(yintercept=value))
g <- g + xlab("\nNumber of outbreaks")
g <- g + ylab("Estimate")
ggsave("consistency.jpg", pointsize=12, width=5.5, height=5.5, units="in")
