function [ dSdt ] = AA_chemostat_2nutrient_dynamics(t,S,params)
% this function defines the chemostat differential equation
%
% get the individual parameters from the vector
%
q    = params(1);
u    = params(2);
r    = params(3);
K    = params(4);
ep   = params(5);
L    = params(6);
F    = params(7);
v    = params(8);
%
% initialize the state's derivative
%
dSdt = zeros(size(S));
%
% put things in terms of individual variables
%
x = S(1); % cells
y = S(2); % food
z = S(3); % ammonium
%
% form the differential equation formulae
%
rxyz  = r*x*y*z/ ((K+y)*(z+L));
dxdt  = (rxyz) - q*x;
dydt  = q*(u - y) - ep*(rxyz);
dzdt  = -F*(rxyz) + q*(v-z);
%
% put things back in terms of state vector variable
%
dSdt(1) = dxdt;
dSdt(2) = dydt;
dSdt(3) = dzdt;
end