function M = PhosphoPaper_050412(SaveAsfilename)
%**************************************************************************
%
% $Id: PhosphoPaper_050319.m,v 1.1 2004/11/15 18:42:29 bhendrik Exp $
% $Revision: 1.1 $
% $Author: bhendrik $
% $Date: 2004/11/15 18:42:29 $
% Type: Matlab script.
%
% Comments: This does the simulations for the Phosphorylation Paper
%
% Written by Bart Hendriks
%
%**************************************************************************
%
% Syntax:
% M = PhosphoPaper_050412(SaveAsfilename)
%
% SaveAsfilename - name of the file where the results get stored.
% M - a 'Model' object that contains all the species, parameters,
% compartments, reactions and runnings of the model
%





load('PhoshoPaper_123To100_S0'); % this loads model 'M'

CellType = 1;   
switch CellType
    case 1
        % H292
        ksyn_R1 = 3;
        ksyn_R2 = 0.3;
        ksyn_R3 = 1.6;
        ksyn_R4 = 0;
        ksyn_R1m = 0;  
end;
% convert synthesis rates to nM/sec:
PMCF = M.ConversionFactor.PMCF;
CPL = M.ConversionFactor.CPL;
ksyn_R1 = ksyn_R1/PMCF*CPL;  % These are synthesis rates, now converted to nM/sec
ksyn_R2 = ksyn_R2/PMCF*CPL;
ksyn_R3 = ksyn_R3/PMCF*CPL;
ksyn_R4 = ksyn_R4/PMCF*CPL;
ksyn_R1m = ksyn_R1m/PMCF*CPL;


%++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
% Do runs for TGFa & HRG:
% TGFa is simulated by simply changing the on and off rates for EGF. 
% TGF-alpha rate constants are from PMID: 7876195. 
%
TGFa_doses = [200 100 20 2 0.2];
HRG_doses = [80 10 1 0.1 0.01];

tic;
RunNumber = 0;

RunNumber = RunNumber + 1;
SS_Run = RunNumber;
RunName = 'Approach to SS';
M = InitializeModelRun(M, RunNumber, RunName,  ...
    'ksyn_R1', ksyn_R1, ...
    'ksyn_R2', ksyn_R2, ...
    'ksyn_R3', ksyn_R3, ...
    'konEGF', 4.3e7*1e-9/60, ...
    'koffEGF', 0.27/60, ...
    'EGF', 0, ...
    'HRG', 0);
M = SSReceptorGuesses(M, RunNumber);
tspan = [0:100000:1000000];
M= SolveModel(M, RunNumber, tspan);
toc;

% RUNS 2 through 6 ........................
for i=1:length(TGFa_doses)
    RunNumber = RunNumber + 1;
    RunName = sprintf('H292 cells: %g nM TGFa, Equal surface & internal dephosphorylation', TGFa_doses(i));
    M = InitializeModelRun(M, RunNumber, RunName, SS_Run, ...
        'k_exp_decay_surface', 0.003, ...
        'k_exp_decay_inside', 0.003, ...
        'EGF', TGFa_doses(i), ...
        'HRG', 0);
    tspan = [0:1:300 330:30:1800 2400:120:7200]; %  timepoints for simulation (This is in SECONDS!)
    M = SolveModel(M, RunNumber, tspan);
    toc; 
end;

% RUNS 7 through 11 ........................
for i=1:length(TGFa_doses)
    RunNumber = RunNumber + 1;
    RunName = sprintf('H292 cells: %g nM TGFa, no surface dephosphorylation', TGFa_doses(i));
    M = InitializeModelRun(M, RunNumber, RunName, SS_Run, ...
        'k_exp_decay_surface', 0, ...
        'k_exp_decay_inside', 0.003, ...
        'EGF', TGFa_doses(i), ...
        'HRG', 0);
    tspan = [0:1:300 330:30:1800 2400:120:7200]; %  timepoints for simulation (This is in SECONDS!)
    M = SolveModel(M, RunNumber, tspan);
    toc; 
end;

% RUNS 12 through 16 ........................
for i=1:length(TGFa_doses)
    RunNumber = RunNumber + 1;
    RunName = sprintf('H292 cells: %g nM TGFa, no internal dephosphorylation', TGFa_doses(i));
    M = InitializeModelRun(M, RunNumber, RunName, SS_Run, ...
        'k_exp_decay_surface', 0.003, ...
        'k_exp_decay_inside', 0, ...
        'EGF', TGFa_doses(i), ...
        'HRG', 0);
    tspan = [0:1:300 330:30:1800 2400:120:7200]; %  timepoints for simulation (This is in SECONDS!)
    M = SolveModel(M, RunNumber, tspan);
    toc; 
end;

% :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
% HRG simulations ...

% RUNS 17 through 21 ........................
for i=1:length(HRG_doses)
    RunNumber = RunNumber + 1;
    RunName = sprintf('H292 cells: %g nM HRG, equal surface & internal dephosphorylation', HRG_doses(i));
    M = InitializeModelRun(M, RunNumber, RunName, SS_Run, ...
        'k_exp_decay_surface', 0.003, ...
        'k_exp_decay_inside', 0.003, ...
        'EGF', 0, ...
        'HRG', HRG_doses(i));
    tspan = [0:1:300 330:30:1800 2400:120:7200]; %  timepoints for simulation (This is in SECONDS!)
    M = SolveModel(M, RunNumber, tspan);
    toc; 
end;

% RUNS 22 through 26 ........................
for i=1:length(HRG_doses)
    RunNumber = RunNumber + 1;
    RunName = sprintf('H292 cells: %g nM HRG, no surface dephosphorylation', HRG_doses(i));
    M = InitializeModelRun(M, RunNumber, RunName, SS_Run, ...
        'k_exp_decay_surface', 0, ...
        'k_exp_decay_inside', 0.003, ...
        'EGF', 0, ...
        'HRG', HRG_doses(i));
    tspan = [0:1:300 330:30:1800 2400:120:7200]; %  timepoints for simulation (This is in SECONDS!)
    M = SolveModel(M, RunNumber, tspan);
    toc; 
end;

% RUNS 27 through 31 ........................
for i=1:length(HRG_doses)
    RunNumber = RunNumber + 1;
    RunName = sprintf('H292 cells: %g nM HRG, no internal dephosphorylation', HRG_doses(i));
    M = InitializeModelRun(M, RunNumber, RunName, SS_Run, ...
        'k_exp_decay_surface', 0.003, ...
        'k_exp_decay_inside', 0, ...
        'EGF', 0, ...
        'HRG', HRG_doses(i));
    tspan = [0:1:300 330:30:1800 2400:120:7200]; %  timepoints for simulation (This is in SECONDS!)
    M = SolveModel(M, RunNumber, tspan);
    toc; 
end;
clear SS_Run;
%++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++



save(SaveAsfilename, 'M', '-compress');  
    


PhosphoPaperPlots(M, [2:6], 'TGFa, surface + inside dephosphorylation');
PhosphoPaperPlots(M, [7:11], 'TGFa, inside dephosphorylation only');
PhosphoPaperPlots(M, [12:16], 'TGFa, surface dephosphorylation only'); 
PhosphoPaperPlots(M, [17:21], 'HRG, surface + inside dephosphorylation'); 
PhosphoPaperPlots(M, [22:26], 'HRG, inside dephosphorylation only'); 
PhosphoPaperPlots(M, [27:31], 'HRG, surface dephosphorylation only');

return;
