function PhosphoPaperPlots(aModel, RunNumber, FigureTitle)
%
%**************************************************************************
%
% $Id: PhosphoPlots.m,v 1.1 2004/11/04 20:14:05 bhendrik Exp $
% $Revision: 1.1 $
% $Author: bhendrik $
% $Date: 2004/11/04 20:14:05 $
% Type: Matlab script.
%
% Comments: This does plots time courses of total receptor and fraction
% phosphorylated.
%
% Written by Bart Hendriks
%
%**************************************************************************
%
%
% Syntax:
% PhosphoPlots(aModel, RunNumber)
%
% where aModel is a 'Model' object and RunNumber is a vector of the runs you
% want plotted.
%
%
% aModel.ModelRun(j).time needs to be in sec!!
%

warning off;

LW = 1;
MS = 4;

Markers = ['-ok'; '-sr'; '-dg'; '-^b'; '-vm'; '->c'; '-<y'];
%colors = ['r', 'g', 'b', 'c', 'm', 'k', 'y', 'r', 'g', 'b', 'c', 'm', 'k', 'y', 'r', 'g', 'b', 'c', 'm', 'k', 'y', 'r', 'g', 'b', 'c', 'm', 'k'];
colors = ['k' 'k' 'k' 'k' 'k' 'k' 'k' 'k' 'k' 'k' 'k' 'k' 'k' 'k' 'k' 'k' 'k' 'k' 'k' 'k' 'k' 'k' 'k' 'k' 'k' 'k' 'k' 'k' 'k' 'k' 'k' 'k' 'k' 'k'];

CPL = aModel.ConversionFactor.CPL;
PMCF = aModel.ConversionFactor.PMCF;
EMCF = aModel.ConversionFactor.EMCF;
CYCF = aModel.ConversionFactor.CYCF;


figure;
for j=RunNumber
    
    subplot(2,2,1);
    hold on;
    plot(aModel.ModelRun(j).time/60, aModel.ModelRun(j).Results(:,GPN(aModel.Species, 'Frxn_ErbB1#P')), '-', 'LineWidth', LW, 'Color', colors(j));  
    xlabel('time (min)');
    ylabel('pErbB1/ErbB1');
    set(gca,'XTick',[0 15 30 45 60 90 120]);
    axis([0 60 0 0.5]);
    title('Frxn ErbB1#P');
    %legend('Frxn ErbB1#P');
    set(gca, 'Box', 'On');
    %grid on;
    hold off;

    
  
    subplot(2,2,2);
    hold on;
    plot(aModel.ModelRun(j).time/60, aModel.ModelRun(j).Results(:,GPN(aModel.Species, 'Frxn_ErbB2#P')), '-', 'LineWidth', LW, 'Color', colors(j));  
    xlabel('time (min)');
    ylabel('pErbB2/ErbB2');
    set(gca,'XTick',[0 15 30 45 60 90 120]);
    axis([0 60 0 0.5]);
    title('Frxn ErbB2#P');
    %legend('Frxn ErbB2#P');
    set(gca, 'Box', 'On');
    %grid on;
    hold off;
    
    
        
    subplot(2,2,3);
    hold on;
    plot(aModel.ModelRun(j).time/60, aModel.ModelRun(j).Results(:,GPN(aModel.Species, 'Frxn_ErbB3#P')), '-', 'LineWidth', LW, 'Color', colors(j));  
    xlabel('time (min)');
    ylabel('pErbB3/ErbB3');
    set(gca,'XTick',[0 15 30 45 60 90 120]);
    axis([0 60 0 0.5]);
    title('Frxn ErbB3#P');
    %legend('Frxn ErbB3#P');
    set(gca, 'Box', 'On');
    %grid on;
    hold off;
        
       
end;

set(gcf, 'Name', FigureTitle);

warning on;

return;