function index = GPN(List, Name)
% This function finds the index number of 'Name' in 'List'
%**************************************************************************
%
% $Id: GPN.m,v 1.2 2004/11/15 18:35:54 bhendrik Exp $
% $Revision: 1.2 $
% $Author: bhendrik $
% $Date: 2004/11/15 18:35:54 $
% Type: Matlab script.
%
% Comments: 
%
% Written by Bart Hendriks
%
%**************************************************************************
%
%




if iscell(Name) 
    Name = num2str(cell2mat(Name)); % convert cell to string
end;
if isa(Name, 'double')
    Name = num2str(Name); % convert to string so that strtrim will work.
end;
Name = strtrim(Name);
% strtrim removes leading and trailing white spaces from a string, it
% allows the function to identify that ' Bart', 'Bart ' and 'Bart' are all
% the same string. It does not do a similar thing for the names in List
% because it would take forever and empty names are of class 'double' which
% makes strtrim crash. 

index = 0;
switch class(List)
    case 'Species'
        for i=1:size(List,2)
            try
                if strcmp(List(i).Name, Name)
                    index = i;
                    break;
                end;
            catch
                if strcmp(List(i).name, Name)
                    index = i;
                    break;
                end;
            end;
        end;
    case 'Parameter'
        for i=1:size(List,2)
            try
                if strcmp(List(i).Name, Name)
                    index = i;
                    break;
                end;
            catch
                if strcmp(List(i).name, Name)
                    index = i;
                    break;
                end;
            end;
        end;
    case 'Compartment'
        for i=1:size(List,2)
            try
                if strcmp(List(i).Name, Name)
                    index = i;
                    break;
                end;
            catch
                if strcmp(List(i).name, Name)
                    index = i;
                    break;
                end;
            end;
        end;
    case 'struct'
        for i=1:size(List,2)
            try
                if strcmp(List(i).Name, Name)
                    index = i;
                    break;
                end;
            catch
                if strcmp(List(i).name, Name)
                    index = i;
                    break;
                end;
            end;
            try
                if strcmp(List(i).id, Name)
                    index = i;
                    break;
                end;
            end;
        end;
    otherwise
        error('Can''t handle input of class %s', class(List));
end;

if index == 0
    warning('Could not find %s!', Name);
end;
return;