function b = subsref(a,index)
%SUBSREF Define field name indexing for Species objects
%**************************************************************************
%
% $Id: subsref.m,v 1.1 2004/11/04 20:14:01 bhendrik Exp $
% $Revision: 1.1 $
% $Author: bhendrik $
% $Date: 2004/11/04 20:14:01 $
% Type: Matlab script.
%
% Comments: 
%
% Written by Bart Hendriks
%
%**************************************************************************

switch index(1).type
    case '()'
        ObjectIndex = cell2mat(index(1).subs);
        if length(index) > 1
            switch index(2).type
                case '.'
                    switch index(2).subs
                        case 'Name'
                            b = a(ObjectIndex).Name;
                        case 'Number'
                            b = a(ObjectIndex).Number;
                        case 'IC'
                            b = a(ObjectIndex).IC;
                        case 'Units'
                            b = a(ObjectIndex).Units;
                        case 'Location'
                            b = a(ObjectIndex).Location;
                        case 'Boundary'
                            b = a(ObjectIndex).Boundary;
                        case 'ConstantSpecies'
                            b = a(ObjectIndex).ConstantSpecies;
                        case 'SubSpecies'
                            if length(index) > 2
                                ObjectIndex3 = cell2mat(index(3).subs);
                                switch index(3).type
                                    case '()'
                                        b = a(ObjectIndex).SubSpecies(ObjectIndex3);
                                    case '{}'
                                        b = a(ObjectIndex).SubSpecies{ObjectIndex3};
                                    case '.'
                                        error('SubSpecies is not a struct!');
                                end;
                            else
                                b = a(ObjectIndex).SubSpecies;
                            end;
                        otherwise
                            error('Invalid field name')
                    end;
            end;
        else
            if isempty(ObjectIndex)
                b = a;
            else
                b = a(ObjectIndex);
            end;
        end;
    case '.'
        error('Species.Fieldname syntax not supported by subsref.m');
    case '{}'
        error('Cell array indexing not supported by Species objects'); 
    otherwise
        b = a;
end;
                
return;