function a = subsasgn(a,index, val)
%SUBSASGN Define index assignment for Species objects
%**************************************************************************
%
% $Id: subsasgn.m,v 1.1 2004/11/04 20:14:00 bhendrik Exp $
% $Revision: 1.1 $
% $Author: bhendrik $
% $Date: 2004/11/04 20:14:00 $
% Type: Matlab script.
%
% Comments: 
%
% Written by Bart Hendriks
%
%**************************************************************************

switch index(1).type
    case '()'
        ObjectIndex = cell2mat(index(1).subs);
        if length(index) > 1
            switch index(2).type
                case '.'
                    switch index(2).subs
                        case 'Name'
                            a(ObjectIndex).Name = val;
                        case 'Number'
                            a(ObjectIndex).Number = val;
                        case 'IC'
                            a(ObjectIndex).IC = val;
                        case 'Units'
                            a(ObjectIndex).Units = val;
                        case 'Location'
                            a(ObjectIndex).Location = val;
                        case 'Boundary'
                            a(ObjectIndex).Boundary = val;
                        case 'ConstantSpecies'
                            a(ObjectIndex).ConstantSpecies = val;
                        case 'CompoundSpecies'
                            a(ObjectIndex).CompoundSpecies = val;
                        otherwise
                            error('Invalid field name')
                    end;
            end;
        else
            a(ObjectIndex) = val ;
        end;
    case '.'
        error('Must assign values to individual Species.');
    case '{}'
        error('Cell array indexing not supported by Species objects') 
    otherwise
        a = val;
end;
                
return;