function aSpecies = set(aSpecies,varargin)
% Species set
%**************************************************************************
%
% $Id: set.m,v 1.1 2004/11/04 20:14:00 bhendrik Exp $
% $Revision: 1.1 $
% $Author: bhendrik $
% $Date: 2004/11/04 20:14:00 $
% Type: Matlab script.
%
% Comments: 
%
% Written by Bart Hendriks
%
%**************************************************************************

property_argin = varargin;

if length(property_argin) == 1
    % in this case the input is a struct
    InputStruct = property_argin{1};
    if isfield(InputStruct, 'Name')
        aSpecies.Name = InputStruct.Name ;
    end;
    if isfield(InputStruct, 'Number')
        aSpecies.Number = InputStruct.Number ;
    end;
    if isfield(InputStruct, 'Location')
        aSpecies.Location = InputStruct.Location ;
    end;
    if isfield(InputStruct, 'Boundary')
        aSpecies.Boundary = InputStruct.Boundary ;
    end;
    if isfield(InputStruct, 'IC')
        aSpecies.IC = InputStruct.IC ;
    end;
    if isfield(InputStruct, 'Units')
        aSpecies.Units = InputStruct.Units ;
    end;
    if isfield(InputStruct, 'Description')
        aSpecies.Description = InputStruct.Description ;
    end;
    if isfield(InputStruct, 'Reference')
        aSpecies.Reference = InputStruct.Reference ;
    end;
    if isfield(InputStruct, 'ConstantSpecies')
        aSpecies.ConstantSpecies = InputStruct.ConstantSpecies;
    end;
    if isfield(InputStruct, 'CompoundSpecies')
        aSpecies.CompoundSpecies = InputStruct.CompoundSpecies;
    end;
end;

while length(property_argin) >= 2,
    prop = property_argin{1};
    val = property_argin{2};
    property_argin = property_argin(3:end);
    switch prop
        case 'Name'
            aSpecies.Name = val ;
        case 'Number'
            aSpecies.Number = val ;
        case 'Location'
            aSpecies.Location = val ;
        case 'Boundary'
            aSpecies.Boundary = val ;
        case 'IC'
            aSpecies.IC = val ;
        case 'Units'
            aSpecies.Units = val ;
        case 'Description'
            aSpecies.Description = val ;
        case 'Reference'
            aSpecies.Reference = val ;
        case 'ConstantSpecies'
            aSpecies.ConstantSpecies = val ;
        case 'SubSpecies'
            aSpecies.SubSpecies = val ;
        otherwise
            error([prop,' is not a valid ', class(aSpecies), 'property']);
    end;     
end;

return;

