function display(aSpecies)
%  display function for Species class
%**************************************************************************
%
% $Id: display.m,v 1.2 2004/11/15 18:31:36 bhendrik Exp $
% $Revision: 1.2 $
% $Author: bhendrik $
% $Date: 2004/11/15 18:31:36 $
% Type: Matlab script.
%
% Comments: 
%
% Written by Bart Hendriks
%
%**************************************************************************

fprintf('\nSpecies:\n');
for i=1:size(aSpecies,2)
    
    Name = get(aSpecies(i), 'Name');
    Number = get(aSpecies(i), 'Number');
    IC = get(aSpecies(i), 'IC');
    Units = get(aSpecies(i), 'Units');
    
    ConstantSpecies = get(aSpecies(i), 'ConstantSpecies');
    SubSpecies = get(aSpecies(i), 'SubSpecies');
    
    if isempty(Name)
        fprintf('%3g: ', Number);
    else
        fprintf('%3g: %35s  %9.3g %s ', Number, Name, IC, Units);
    end;
    
    
    if ConstantSpecies == 1
        fprintf(' (Constant) \n');
    end;
    if ~isempty(SubSpecies)
        fprintf(' (Has SubSpecies) \n');
    end;
    if (isempty(ConstantSpecies) | ConstantSpecies ~= 1) & isempty(SubSpecies)
        fprintf('\n');
    end;
    
end;

fprintf('\n');


return;