function aSpecies = Species(varargin)
% Species class constructor
%**************************************************************************
%
% $Id: Species.m,v 1.1 2004/11/04 20:13:59 bhendrik Exp $
% $Revision: 1.1 $
% $Author: bhendrik $
% $Date: 2004/11/04 20:13:59 $
% Type: Matlab script.
%
% Comments: 
%
% Written by Bart Hendriks
%
%**************************************************************************


switch length(varargin)
    case 0  
        structSpecies= struct('Name', {}, ...
            'Number', {} , ...
            'Location', {} , ...
            'Boundary', {} , ...
            'IC', {} , ...
            'Units', {} , ...
            'Description', {} , ...
            'Reference',  {} , ...
            'ConstantSpecies', {}, ...
            'SubSpecies', {} ...
             );
        structSpecies(1).Name = 'Empty Species';  
        aSpecies = class(structSpecies,'Species');
    case 1  
        if isa(varargin{1},'Species')
            aSpecies = varargin{1};
        elseif isa(varargin{1},'struct')
            SpeciesInput = varargin{1};
            
            aSpecies = Species;
            aSpecies = set(aSpecies, ...
                'Name', SpeciesInput(1).Name , ...
                'Number', SpeciesInput(1).Number , ...
                'Location', SpeciesInput(1).Location , ...
                'Boundary', SpeciesInput(1).Boundary , ...
                'IC', SpeciesInput(1).IC , ...
                'Units', SpeciesInput(1).Units , ...
                'Description',  SpeciesInput(1).Description , ...
                'Reference', SpeciesInput(1).Reference,   ...
                'ConstantSpecies', SpeciesInput(1).ConstantSpecies , ...
                'SubSpecies', SpeciesInput(1).SubSpecies ...
                );
        else
            error(['Argument to Species is of class',class(varargin{1})]);
        end;
    otherwise   
        error('Cannot initialize');
end;

return;

