function b = subsref(a,index)
%SUBSREF Define field name indexing for Reaction objects
%**************************************************************************
%
% $Id: subsref.m,v 1.1 2004/11/04 20:13:58 bhendrik Exp $
% $Revision: 1.1 $
% $Author: bhendrik $
% $Date: 2004/11/04 20:13:58 $
% Type: Matlab script.
%
% Comments: 
%
% Written by Bart Hendriks
%
%**************************************************************************


switch index(1).type
    case '()'
        ObjectIndex = cell2mat(index(1).subs);
        if length(index) > 1
            switch index(2).type
                case '.'
                    switch index(2).subs
                        case 'Name'
                            b = a(ObjectIndex).Name;
                        case 'Number'
                            b = a(ObjectIndex).Number;
                        case 'Reactant_1'
                            b = a(ObjectIndex).Reactant_1;
                        case 'Reactant_2'
                            b = a(ObjectIndex).Reactant_2;
                        case 'Product_1'
                            b = a(ObjectIndex).Product_1;
                        case 'Product_2'
                            b = a(ObjectIndex).Product_2;
                        case 'Modifier_1'
                            b = a(ObjectIndex).Modifier_1;
                        case 'Modifier_2'
                            b = a(ObjectIndex).Modifier_2;
                        case 'Modifier_3'
                            b = a(ObjectIndex).Modifier_3;
                        case 'Parameter_1'
                            b = a(ObjectIndex).Parameter_1;
                        case 'Parameter_2'
                            b = a(ObjectIndex).Parameter_2;
                        case 'Parameter_3'
                            b = a(ObjectIndex).Parameter_3;
                        case 'Parameter_4'
                            b = a(ObjectIndex).Parameter_4;
                        case 'Parameter_5'
                            b = a(ObjectIndex).Parameter_5;
                        case 'Flux'
                            b = a(ObjectIndex).Flux;
                        otherwise
                            error('Invalid field name')
                    end;
            end;
        else
            if isempty(ObjectIndex)
                b = a;
            else
                b = a(ObjectIndex);
            end;
        end;
    case '{}'
        error('Cell array indexing not supported by Reaction objects') ;
    case '.'
        error('Reaction.Fieldname syntax not supported by subsref.m');
    otherwise
        b = a;
end;
                
return;