function a = subsasgn(a,index,val)
%SUBSASGN Define index assignment for Reaction objects
%**************************************************************************
%
% $Id: subsasgn.m,v 1.1 2004/11/04 20:13:58 bhendrik Exp $
% $Revision: 1.1 $
% $Author: bhendrik $
% $Date: 2004/11/04 20:13:58 $
% Type: Matlab script.
%
% Comments: 
%
% Written by Bart Hendriks
%
%**************************************************************************

switch index(1).type
    case '()'
        ObjectIndex = cell2mat(index(1).subs);
        if length(index) > 1
            switch index(2).type
                case '.'
                    switch index(2).subs
                        case 'Name'
                            a(ObjectIndex).Name = val;
                        case 'Number'
                            a(ObjectIndex).Number = val;
                        case 'Reactant_1'
                            a(ObjectIndex).Reactant_1 = val;
                        case 'Reactant_2'
                            a(ObjectIndex).Reactant_2 = val;
                        case 'Product_1'
                            a(ObjectIndex).Product_1 = val;
                        case 'Product_2'
                            a(ObjectIndex).Product_2 = val;
                        case 'Modifier_1'
                            a(ObjectIndex).Modifier_1 = val;
                        case 'Modifier_2'
                            a(ObjectIndex).Modifier_2 = val;
                        case 'Modifier_3'
                            a(ObjectIndex).Modifier_3 = val;
                        case 'Parameter_1'
                            a(ObjectIndex).Parameter_1 = val;
                        case 'Parameter_2'
                            a(ObjectIndex).Parameter_2 = val;
                        case 'Parameter_3'
                            a(ObjectIndex).Parameter_3 = val;
                        case 'Parameter_4'
                            a(ObjectIndex).Parameter_4 = val;
                        case 'Parameter_5'
                            a(ObjectIndex).Parameter_5 = val;
                        case 'Flux'
                            a(ObjectIndex).Flux = val;
                        otherwise
                            error('Invalid field name');
                    end;
            end;
        else
            a(ObjectIndex) = val;
        end;
    case '.'
        error('Must assign values to individual Reactions.');
    case '{}'
        error('Cell array indexing not supported by Reaction objects') 
    otherwise 
        a = val;
end;
                
return;