function aReaction = set(aReaction,varargin)
% Reaction set
%**************************************************************************
%
% $Id: set.m,v 1.1 2004/11/04 20:13:57 bhendrik Exp $
% $Revision: 1.1 $
% $Author: bhendrik $
% $Date: 2004/11/04 20:13:57 $
% Type: Matlab script.
%
% Comments: 
%
% Written by Bart Hendriks
%
%**************************************************************************

property_argin = varargin;


if length(property_argin) == 1
    % in this case the input is a struct
    InputStruct = property_argin{1};
    if isfield(InputStruct, 'Name')
        aReaction.Name = InputStruct.Name ;
    end;
    if isfield(InputStruct, 'Number')
        aReaction.Number = InputStruct.Number ;
    end;
    if isfield(InputStruct, 'Reactant_1')
        aReaction.Reactant_1 = InputStruct.Reactant_1 ;
    end;
    if isfield(InputStruct, 'Reactant_2')
        aReaction.Reactant_2 = InputStruct.Reactant_2 ;
    end;
    if isfield(InputStruct, 'Product_1')
        aReaction.Product_1 = InputStruct.Product_1 ;
    end;
    if isfield(InputStruct, 'Product_2')
        aReaction.Product_2 = InputStruct.Product_2 ;
    end;
    if isfield(InputStruct, 'Modifier_1')
        aReaction.Modifier_1 = InputStruct.Modifier_1 ;
    end;
    if isfield(InputStruct, 'Modifier_2')
        aReaction.Modifier_2 = InputStruct.Modifier_2 ;
    end;
    if isfield(InputStruct, 'Modifier_3')
        aReaction.Modifier_3 = InputStruct.Modifier_3 ;
    end;
    if isfield(InputStruct, 'Parameter_1')
        aReaction.Parameter_1 = InputStruct.Parameter_1 ;
    end;
    if isfield(InputStruct, 'Parameter_2')
        aReaction.Parameter_2 = InputStruct.Parameter_2 ;
    end;
    if isfield(InputStruct, 'Parameter_3')
        aReaction.Parameter_3 = InputStruct.Parameter_3 ;
    end;
    if isfield(InputStruct, 'Parameter_4')
        aReaction.Parameter_4 = InputStruct.Parameter_4 ;
    end;
    if isfield(InputStruct, 'Parameter_5')
        aReaction.Parameter_5 = InputStruct.Parameter_5 ;
    end;
    if isfield(InputStruct, 'Flux')
        aReaction.Flux = InputStruct.Flux ;
    end;
end;

while length(property_argin) >= 2,
    prop = property_argin{1};
    val = property_argin{2};
    property_argin = property_argin(3:end);
    switch prop
        case 'Name'
            aReaction.Name = val ;
        case 'Number'
            aReaction.Number = val ;
        case 'Reactant_1'
            aReaction.Reactant_1 = val ;
        case 'Reactant_2'
            aReaction.Reactant_2 = val ;
        case 'Product_1'
            aReaction.Product_1 = val ;
        case 'Product_2'
            aReaction.Product_2 = val ;
        case 'Modifier_1'
            aReaction.Modifier_1 = val ;
        case 'Modifier_2'
            aReaction.Modifier_2 = val ;
        case 'Modifier_3'
            aReaction.Modifier_3 = val ;
        case 'Parameter_1'
            aReaction.Parameter_1 = val ;
        case 'Parameter_2'
            aReaction.Parameter_2 = val ;
        case 'Parameter_3'
            aReaction.Parameter_3 = val ;
        case 'Parameter_4'
            aReaction.Parameter_4 = val ;
        case 'Parameter_5'
            aReaction.Parameter_5 = val ;
        case 'Flux'
            aReaction.Flux = val ;
        otherwise
            error([prop,' is not a valid ', class(aReaction), 'property']);
    end;     
end;

return;

