function display(aReaction)
%  display function for Reaction class
%**************************************************************************
%
% $Id: display.m,v 1.1 2004/11/04 20:13:56 bhendrik Exp $
% $Revision: 1.1 $
% $Author: bhendrik $
% $Date: 2004/11/04 20:13:56 $
% Type: Matlab script.
%
% Comments: 
%
% Written by Bart Hendriks
%
%**************************************************************************
fprintf('\n');
for i=1:size(aReaction,2)
    
    Name = get(aReaction(i), 'Name');
    Number = get(aReaction(i), 'Number');
    
    if isempty(Number)
        Number = i;
    end;
    if isempty(Name)
        Name = '-';
    end;
    Reactant_1 = get(aReaction(i), 'Reactant_1');
    Reactant_2 = get(aReaction(i), 'Reactant_2');
    Product_1 = get(aReaction(i), 'Product_1');
    Product_2 = get(aReaction(i), 'Product_2');
    Modifier_1 = get(aReaction(i), 'Modifier_1');
    Modifier_2 = get(aReaction(i), 'Modifier_2');
    Modifier_3 = get(aReaction(i), 'Modifier_3');
    Parameter_1 = get(aReaction(i), 'Parameter_1');
    Parameter_2 = get(aReaction(i), 'Parameter_2');
    Parameter_3 = get(aReaction(i), 'Parameter_3');
    Parameter_4 = get(aReaction(i), 'Parameter_4');
    Parameter_5 = get(aReaction(i), 'Parameter_5');
    Flux = get(aReaction(i), 'Flux');
    
    fprintf('Reaction #%g:\nName: %s\n', Number, Name);
    if ~isempty(Reactant_1)
        fprintf('Reactant_1: %s\n', Reactant_1);
    end;
    if ~isempty(Reactant_2)
        fprintf('Reactant_2: %s\n', Reactant_2);
    end;
    if ~isempty(Product_1)
        fprintf('Product_1: %s\n', Product_1);
    end;
    if ~isempty(Product_2)
        fprintf('Product_2: %s\n', Product_2);
    end;
    if ~isempty(Modifier_1)
        fprintf('Modifier_1: %s\n', Modifier_1);
    end;
    if ~isempty(Modifier_2)
        fprintf('Modifier_2: %s\n', Modifier_2);
    end;
    if ~isempty(Modifier_3)
        fprintf('Modifier_3: %s\n', Modifier_3);
    end;
    if ~isempty(Parameter_1)
        fprintf('Parameter_1: %s\n', Parameter_1);
    end;
    if ~isempty(Parameter_2)
        fprintf('Parameter_2: %s\n', Parameter_2);
    end;
    if ~isempty(Parameter_3)
        fprintf('Parameter_3: %s\n', Parameter_3);
    end;
    if ~isempty(Parameter_4)
        fprintf('Parameter_4: %s\n', Parameter_4);
    end;
    if ~isempty(Parameter_5)
        fprintf('Parameter_5: %s\n', Parameter_5);
    end;
    fprintf('Flux = %s\n\n', Flux);
    
end;

fprintf('\n');


return;