function aReaction = Reaction(varargin)
% Reaction class constructor
%**************************************************************************
%
% $Id: Reaction.m,v 1.1 2004/11/04 20:13:56 bhendrik Exp $
% $Revision: 1.1 $
% $Author: bhendrik $
% $Date: 2004/11/04 20:13:56 $
% Type: Matlab script.
%
% Comments: 
%
% Written by Bart Hendriks
%
%**************************************************************************


switch length(varargin)
    case 0  
        structReaction= struct('Name', {}, ...
            'Number', {} , ...
            'Reactant_1', {} , ...
            'Reactant_2', {} , ...
            'Product_1', {} , ...
            'Product_2',  {}, ...
            'Modifier_1', {} , ...
            'Modifier_2', {} , ...
            'Modifier_3',  {}, ...
            'Parameter_1', {} , ...
            'Parameter_2',  {}, ...
            'Parameter_3',  {}, ...
            'Parameter_4',  {}, ...
            'Parameter_5',  {}, ...
            'Flux', {} ...
             );
        structReaction(1).Name = 'Empty Reaction';  
        aReaction = class(structReaction,'Reaction');
    case 1  
        if isa(varargin{1},'Reaction')
            aReaction = varargin{1};
        elseif isa(varargin{1},'struct')
            ReactionInput = varargin{1};
            
            aReaction = Reaction;
            aReaction = set(aReaction, ...
                'Name', ReactionInput(1).Name , ...
                'Number', ReactionInput(1).Number , ...
                'Reactant_1', ReactionInput(1).Reactant_1 , ...
                'Reactant_2', ReactionInput(1).Reactant_2 , ...
                'Product_1', ReactionInput(1).Product_1 , ...
                'Product_2', ReactionInput(1).Product_2 , ...
                'Modifier_1', ReactionInput(1).Modifier_1 , ...
                'Modifier_2', ReactionInput(1).Modifier_2 , ...
                'Modifier_3', ReactionInput(1).Modifier_3 , ...
                'Parameter_1', ReactionInput(1).Parameter_1 , ...
                'Parameter_2', ReactionInput(1).Parameter_2 , ...
                'Parameter_3', ReactionInput(1).Parameter_3 , ...
                'Parameter_4', ReactionInput(1).Parameter_4 , ...
                'Parameter_5', ReactionInput(1).Parameter_5 , ...
                'Flux', ReactionInput(1).Flux ...
                );
        else
            error(['Argument to Reaction is of class',class(varargin{1})]);
        end;
    otherwise   
        error('Cannot initialize');
end;

return;

