function a = subsasgn(a,index,val)
%SUBSASGN Define index assignment for Parameter objects
%**************************************************************************
%
% $Id: subsasgn.m,v 1.1 2004/11/04 20:13:55 bhendrik Exp $
% $Revision: 1.1 $
% $Author: bhendrik $
% $Date: 2004/11/04 20:13:55 $
% Type: Matlab script.
%
% Comments: 
%
% Written by Bart Hendriks
%
%**************************************************************************

switch index(1).type
    case '()'
        ObjectIndex = cell2mat(index(1).subs);
        if length(index) > 1
            switch index(2).type
                case '.'
                    switch index(2).subs
                        case 'Name'
                            a(ObjectIndex).Name = val;
                        case 'Number'
                            a(ObjectIndex).Number = val;
                        case 'Value'
                            a(ObjectIndex).Value = val;
                        case 'Units'
                            a(ObjectIndex).Units = val;
                        otherwise
                            error('Invalid field name');
                    end;
            end;
        else
            a(ObjectIndex) = val;
        end;
    case '.'
        error('Must assign values to individual Parameters.');
    case '{}'
        error('Cell array indexing not supported by Parameter objects'); 
    otherwise 
        a = val;
end;
                
return;