function aParameter = set(aParameter,varargin)
% Parameter set
%**************************************************************************
%
% $Id: set.m,v 1.1 2004/11/04 20:13:55 bhendrik Exp $
% $Revision: 1.1 $
% $Author: bhendrik $
% $Date: 2004/11/04 20:13:55 $
% Type: Matlab script.
%
% Comments: 
%
% Written by Bart Hendriks
%
%**************************************************************************

property_argin = varargin;


if length(property_argin) == 1
    % in this case the input is a struct
    InputStruct = property_argin{1};
    if isfield(InputStruct, 'Name')
        aParameter.Name = InputStruct.Name ;
    end;
    if isfield(InputStruct, 'Number')
        aParameter.Number = InputStruct.Number ;
    end;
    if isfield(InputStruct, 'Value')
        aParameter.Value = InputStruct.Value ;
    end;
    if isfield(InputStruct, 'Units')
        aParameter.Units = InputStruct.Units ;
    end;
    if isfield(InputStruct, 'Description')
        aParameter.Description = InputStruct.Description ;
    end;
    if isfield(InputStruct, 'Reference')
        aParameter.Reference = InputStruct.Reference ;
    end;
    
end;

while length(property_argin) >= 2,
    prop = property_argin{1};
    val = property_argin{2};
    property_argin = property_argin(3:end);
    switch prop
        case 'Name'
            aParameter.Name = val ;
        case 'Number'
            aParameter.Number = val ;
        case 'Value'
            aParameter.Value = val ;
        case 'Units'
            aParameter.Units = val ;
        case 'Description'
            aParameter.Description = val ;
        case 'Reference'
            aParameter.Reference = val ;
        otherwise
            error([prop,' is not a valid ', class(aParameter), 'property']);
    end;     
end;

return;

