function aParameter = Parameter(varargin)
% Parameter class constructor
%**************************************************************************
%
% $Id: Parameter.m,v 1.1 2004/11/04 20:13:53 bhendrik Exp $
% $Revision: 1.1 $
% $Author: bhendrik $
% $Date: 2004/11/04 20:13:53 $
% Type: Matlab script.
%
% Comments: 
%
% Written by Bart Hendriks
%
%**************************************************************************


switch nargin
    case 0  
        structParameter= struct('Name', {}, ...
            'Number', {} , ...
            'Value', {} , ...
            'Units', {} , ...
            'Description', {} , ...
            'Reference',  {} ...
             );
        structParameter(1).Name = 'Empty Parameter';  
        aParameter = class(structParameter,'Parameter');
    case 1  
        if isa(varargin{1},'Parameter')
            aParameter = varargin{1};
        elseif isa(varargin{1},'struct')
            ParameterInput = varargin{1};
            
            aParameter = Parameter;
            aParameter = set(aParameter, ...
                'Name', ParameterInput(1).Name , ...
                'Number', ParameterInput(1).Number , ...
                'Value', ParameterInput(1).Value , ...
                'Units', ParameterInput(1).Units , ...
                'Description',  ParameterInput(1).Description , ...
                'Reference', ParameterInput(1).Reference   ...
                );
        else
            error(['Argument to Parameter is of class',class(varargin{1})]);
        end;
    otherwise   
        error('Cannot initialize');
end;

return;

