function b = subsref(a,index)
%SUBSREF Define field name indexing for ModelRun objects
%**************************************************************************
%
% $Id: subsref.m,v 1.1 2004/11/04 20:13:53 bhendrik Exp $
% $Revision: 1.1 $
% $Author: bhendrik $
% $Date: 2004/11/04 20:13:53 $
% Type: Matlab script.
%
% Comments: 
%
% Written by Bart Hendriks
%
%**************************************************************************

switch index(1).type
    case '()'
        ObjectIndex = cell2mat(index(1).subs);
        if length(index) > 1
            switch index(2).type
                case '.'
                    if length(index) == 2
                        newindex(1).type = '()';
                        newindex(1).subs = {};
                    else
                        newindex = index(3:length(index));
                    end;
                    switch index(2).subs
                        case 'Name'
                            b = a(ObjectIndex).Name;
                        case 'Number'
                            b = a(ObjectIndex).Number;
                        case 'SpeciesIC'
                            b = subsref(a(ObjectIndex).SpeciesIC, newindex);
                        case 'ParameterValues'
                            b = subsref(a(ObjectIndex).ParameterValues, newindex);
                        case 'CompartmentVolumes'
                            b = subsref(a(ObjectIndex).CompartmentVolumes, newindex);
                        case 'time'
                            b = subsref(a(ObjectIndex).time, newindex);
                        case 'Results'
                            b = subsref(a(ObjectIndex).Results, newindex);
                        otherwise
                            error('Invalid field name.');
                    end;
            end;
        else
            b = a(ObjectIndex);
        end;
    case '.'
        if length(index) == 1
            newindex(1).type = '()';
            newindex(1).subs = {};
        else
            newindex = index(2:length(index));
        end;
        switch index(1).subs
            case 'Name'
                b = a.Name;
            case 'Number'
                b = a.Number;
            case 'SpeciesIC'
                b = subsref(a.SpeciesIC, newindex);
            case 'ParameterValues'
                b = subsref(a.ParameterValues, newindex);
            case 'CompartmentVolumes'
                b = subsref(a.CompartmentVolumes, newindex);
            case 'time'
                b = subsref(a.time, newindex);            
            case 'Results'
                b = subsref(a.Results, newindex);   
            otherwise
                error('Invalid field name.');
        end;
    case '{}'
        error('Cell array indexing not supported by ModelRun objects'); 
    otherwise
        b = a;
end;
                
return;