function a = subsasgn(a,index, val)
%SUBSASGN Define index assignment for ModelRun objects
%**************************************************************************
%
% $Id: subsasgn.m,v 1.2 2004/11/15 18:30:58 bhendrik Exp $
% $Revision: 1.2 $
% $Author: bhendrik $
% $Date: 2004/11/15 18:30:58 $
% Type: Matlab script.
%
% Comments: 
%
% Written by Bart Hendriks
%
%**************************************************************************

switch index(1).type
    case '()'
        ObjectIndex = cell2mat(index(1).subs);
        if length(index) > 1
            switch index(2).type
                case '.'
                    if length(index) == 2
                        newindex(1).type = '()';
                        newindex(1).subs = {};
                    else
                        newindex = index(3:length(index));
                    end;
                    switch index(2).subs
                        case 'Name'
                            a(ObjectIndex).Name = val;
                        case 'Number'
                            a(ObjectIndex).Number = val;
                        case 'SpeciesIC'
                            a(ObjectIndex).SpeciesIC = subsasgn(a(ObjectIndex).SpeciesIC, newindex, val);
                        case 'ParameterValues'
                            a(ObjectIndex).ParameterValues = subsasgn(a(ObjectIndex).ParameterValues, newindex, val);
                        case 'CompartmentVolumes'
                            a(ObjectIndex).CompartmentVolumes = subsasgn(a(ObjectIndex).CompartmentVolumes, newindex, val);
                        case 'time'
                            a(ObjectIndex).time = val;
                        case 'Results'
                            a(ObjectIndex).Results = val;
                        otherwise
                            error('Invalid field name')
                    end;
            end;
        else
            a(ObjectIndex) = val ;
        end;
    case '.'
        if length(index) == 1
            newindex(1).type = '()';
            newindex(1).subs = {};
        else
            newindex = index(2:length(index));
        end;
        switch index(1).subs
            case 'Name'
                a.Name = val;
            case 'Number'
                a.Number = val;
            case 'SpeciesIC'
                a.SpeciesIC = subsasgn(a.SpeciesIC, newindex, val);
            case 'ParameterValues'
                a.ParameterValues = subsasgn(a.ParameterValues, newindex, val);
            case 'CompartmentVolumes'
                a.CompartmentVolumes = subsasgn(a.CompartmentVolumes, newindex, val);
            case 'time'
                a.time = subsasgn(a.time, newindex, val);            
            case 'Results'
                a.Results = subsasgn(a.Results, newindex, val);       
        end;
    case '{}'
        error('Cell array indexing not supported by ModelRun objects')
    otherwise 
        a = val;
end;
                
return;