function aModelRun = set(aModelRun,varargin)
% ModelRun set
%**************************************************************************
%
% $Id: set.m,v 1.1 2004/11/04 20:13:52 bhendrik Exp $
% $Revision: 1.1 $
% $Author: bhendrik $
% $Date: 2004/11/04 20:13:52 $
% Type: Matlab script.
%
% Comments: 
%
% Written by Bart Hendriks
%
%**************************************************************************

property_argin = varargin;

if length(property_argin) == 1
    % in this case the input is a struct
    InputStruct = property_argin{1};
    if isfield(InputStruct, 'Name')
        aModelRun.Name = InputStruct.Name ;
    end;
    if isfield(InputStruct, 'Number')
        aModelRun.Number = InputStruct.Number ;
    end;
    if isfield(InputStruct, 'SpeciesIC')
        aModelRun.Location = InputStruct.Location ;
    end;
    if isfield(InputStruct, 'ParameterValues')
        aModelRun.ParameterValues = InputStruct.ParameterValues ;
    end;
    if isfield(InputStruct, 'CompartmentVolumes')
        aModelRun.CompartmentVolumes = InputStruct.CompartmentVolumes ;
    end;
    if isfield(InputStruct, 'time')
        aModelRun.time = InputStruct.time ;
    end;
    if isfield(InputStruct, 'Results')
        aModelRun.Results = InputStruct.Results ;
    end;
end;

while length(property_argin) >= 2,
    prop = property_argin{1};
    val = property_argin{2};
    property_argin = property_argin(3:end);
    switch prop
        case 'Name'
            aModelRun.Name = val ;
        case 'Number'
            aModelRun.Number = val ;
        case 'SpeciesIC'
            aModelRun.SpeciesIC = val ;
        case 'ParameterValues'
            aModelRun.ParameterValues = val ;
        case 'CompartmentVolumes'
            aModelRun.CompartmentVolumes = val ;
        case 'Reaction'
            aModelRun.Reaction = val ;
        case 'time'
            aModelRun.time = val ;
        case 'Results'
            aModelRun.Results = val ;
        
        otherwise
            error([prop,' is not a valid ', class(aModelRun), 'property']);
    end;     
end;

return;

