function display(aModelRun)
%  display function for ModelRun class
%**************************************************************************
%
% $Id: display.m,v 1.1 2004/11/04 20:13:51 bhendrik Exp $
% $Revision: 1.1 $
% $Author: bhendrik $
% $Date: 2004/11/04 20:13:51 $
% Type: Matlab script.
%
% Comments: 
%
% Written by Bart Hendriks
%
%**************************************************************************

fprintf('\n [%g x %g] ModelRun Object\n\n\n', size(aModelRun,1), size(aModelRun,2));

for i=1:size(aModelRun,2)
    
    Name = get(aModelRun(i), 'Name');
    Number = get(aModelRun(i), 'Number');
    IC = get(aModelRun(i), 'SpeciesIC');
    PV = get(aModelRun(i), 'ParameterValues');
    CV = get(aModelRun(i), 'CompartmentVolumes');
    t = get(aModelRun(i), 'time');
    R = get(aModelRun(i), 'Results');
    
        
    fprintf('\nModel Run #%g:\n', Number);
    fprintf('\nIC: ');
    disp(IC);
    fprintf('\nPV: ');
    disp(PV);
    fprintf('\nCV: ');
    disp(CV);
    fprintf('\nt: ');
    disp(t);
    fprintf('\nResults: ');
    disp(R);
    
    
end;

fprintf('\n');


return;