function b = subsref(a,index)
%SUBSREF Define field name indexing for Model objects
%**************************************************************************
%
% $Id: subsref.m,v 1.1 2004/11/04 20:13:49 bhendrik Exp $
% $Revision: 1.1 $
% $Author: bhendrik $
% $Date: 2004/11/04 20:13:49 $
% Type: Matlab script.
%
% Comments: 
%
% Written by Bart Hendriks
%
%**************************************************************************



switch index(1).type
    case '()'
        ObjectIndex = cell2mat(index(1).subs);
        if length(index) > 1
            switch index(2).type
                case '.'
                    if length(index) == 2
                        newindex(1).type = '()';
                        newindex(1).subs = {};
                    else
                        newindex = index(3:length(index));
                    end;
                    switch index(2).subs
                        case 'Name'
                            b = a(ObjectIndex).Name;
                        case 'Species'
                            b = subsref(a(ObjectIndex).Species, newindex);
                        case 'Parameter'
                            b = subsref(a(ObjectIndex).Parameter, newindex);
                        case 'Reaction'
                            b = subsref(a(ObjectIndex).Reaction, newindex);
                        case 'Compartment'
                            b = subsref(a(ObjectIndex).Compartment, newindex);
                        case 'ODEfilename'
                            b = a(ObjectIndex).ODEfilename;
                        case 'ModelRun'
                            b = subsref(a(ObjectIndex).ModelRun, newindex);
                        case 'ConversionFactor'
                            b = subsref(a(ObjectIndex).ConversionFactor, newindex);
                    end;
            end;
        else
            b = a(ObjectIndex);
        end;
    case '.'
        if length(index) == 1
            newindex(1).type = '()';
            newindex(1).subs = {};
        else
            newindex = index(2:length(index));
        end;
        switch index(1).subs
            case 'Name'
                b = a.Name;
            case 'Species'
                b = subsref(a.Species, newindex);
            case 'Parameter'
                b = subsref(a.Parameter, newindex);
            case 'Reaction'
                b = subsref(a.Reaction, newindex);            
            case 'Compartment'
                b = subsref(a.Compartment, newindex);
            case 'ODEfilename'
                b = a.ODEfilename;
            case 'ModelRun'
                b = subsref(a.ModelRun, newindex);
            case 'ConversionFactor'
                b = subsref(a.ConversionFactor, newindex);           
        end;
    case '{}'
        error('Cell array indexing not supported by Model objects') 
    otherwise
        b = a;
end;
                
return;