function a = subsasgn(a,index, val)
%SUBSASGN Define index assignment for Model objects
%**************************************************************************
%
% $Id: subsasgn.m,v 1.1 2004/11/04 20:13:49 bhendrik Exp $
% $Revision: 1.1 $
% $Author: bhendrik $
% $Date: 2004/11/04 20:13:49 $
% Type: Matlab script.
%
% Comments: 
%
% Written by Bart Hendriks
%
%**************************************************************************



switch index(1).type
    case '()'
        ObjectIndex = cell2mat(index(1).subs);
        if length(index) > 1
            switch index(2).type
                case '.'
                    if length(index) == 2
                        newindex(1).type = '()';
                        newindex(1).subs = {};
                    else
                        newindex = index(3:length(index));
                    end;
                    switch index(2).subs
                        case 'Name'
                            a(ObjectIndex).Name = val;
                        case 'Species'
                            a(ObjectIndex).Species = subsasgn(a(ObjectIndex).Species, newindex, val);
                        case 'Parameter'
                            a(ObjectIndex).Parameter = subsasgn(a(ObjectIndex).Parameter, newindex, val);
                        case 'Reaction'
                            a(ObjectIndex).Reaction = subsasgn(a(ObjectIndex).Reaction, newindex, val);
                        case 'Compartment'
                            a(ObjectIndex).Compartment = subsasgn(a(ObjectIndex).Compartment, newindex, val);
                        case 'ODEfilename'
                            a(ObjectIndex).ODEfilename = val;
                        case 'ModelRun'
                            a(ObjectIndex).ModelRun = subsasgn(a(ObjectIndex).ModelRun, newindex, val);
                        case 'ConversionFactor'
                            a(ObjectIndex).ConversionFactor = subsasgn(a(ObjectIndex).ConversionFactor, newindex, val);
                    end;
            end;
        else
            a(ObjectIndex) = val;
        end;
    case '.'
        if length(index) == 1
            newindex(1).type = '()';
            newindex(1).subs = {};
        else
            newindex = index(2:length(index));
        end;
        switch index(1).subs
            case 'Name'
                a.Name = val;
            case 'Species'
                a.Species = subsasgn(a.Species, newindex, val);
            case 'Parameter'
                a.Parameter = subsasgn(a.Parameter, newindex, val);
            case 'Reaction'
                a.Reaction = subsasgn(a.Reaction, newindex, val);            
            case 'Compartment'
                a.Compartment = subsasgn(a.Compartment, newindex, val);
            case 'ODEfilename'
                a.ODEfilename = val;
            case 'ModelRun'
                a.ModelRun = subsasgn(a.ModelRun, newindex, val);
            case 'ConversionFactor'
                a.ConversionFactor = subsasgn(a.ConversionFactor, newindex, val);         
        end;
    case '{}'
        error('Cell array indexing not supported by Model objects'); 
    otherwise
        a = val;
end;
                
return;