function aModel = set(aModel,varargin)
% Model set
%**************************************************************************
%
% $Id: set.m,v 1.1 2004/11/04 20:13:48 bhendrik Exp $
% $Revision: 1.1 $
% $Author: bhendrik $
% $Date: 2004/11/04 20:13:48 $
% Type: Matlab script.
%
% Comments: 
%
% Written by Bart Hendriks
%
%**************************************************************************

property_argin = varargin;
while length(property_argin) >= 2,
    prop = property_argin{1};
    val = property_argin{2};
    property_argin = property_argin(3:end);
    switch prop
        case 'Name'
            aModel.Name = val ;
        case 'Species'
            % in this case val is the species struct
            aSpecies = Species;
            for i=1:size(val, 2)
                aSpecies(i) = Species;
                aSpecies(i) = set(aSpecies(i), val(i));
            end;
            aModel.Species = aSpecies;
        case 'Parameter'
            % in this case val is the parameter struct
            aParameter = Parameter;
            for i=1:size(val, 2)
                aParameter(i) = Parameter;
                aParameter(i) = set(aParameter(i), val(i));
            end;
            aModel.Parameter = aParameter;
        case 'Reaction'
            % in this case val is the species struct
            aReaction = Reaction;
            for i=1:size(val, 2)
                aReaction(i) = Reaction;
                aReaction(i) = set(aReaction(i), val(i));
            end;
            aModel.Reaction = aReaction;
        case 'Compartment'
            % in this case val is the species struct
            aCompartment = Compartment;
            for i=1:size(val, 2)
                aCompartment(i) = Compartment;
                aCompartment(i) = set(aCompartment(i), val(i));
            end;
            aModel.Compartment = aCompartment;
        case 'ConversionFactor'
            aConversionFactor = ConversionFactor;
            aConversionFactor = set(aConversionFactor, val);
            aModel.ConversionFactor = aConversionFactor;
        case 'ConstantSpecies'
            for i=1:size(val, 2)
                if ~isempty(val(i).Name)
                    SpeciesOfInterest = val(i).Name;
                    index = GPN(aModel.Species, SpeciesOfInterest);
                    aModel.Species(index) = set(aModel.Species(index), 'ConstantSpecies', 1);
                end;
            end;
        case 'CompoundSpecies'
            for i=1:size(val, 2)
                if ~isempty(val(i).Name)
                    SpeciesOfInterest = val(i).Name;
                    SubSpecies = val(i).SubSpecies;
                    index = GPN(aModel.Species, SpeciesOfInterest);
                    aModel.Species(index) = set(aModel.Species(index), 'SubSpecies', SubSpecies);
                end;
            end;
        case 'ODEfilename'
            aModel.ODEfilename = val;
        case 'ModelRun'
            aModelRun = ModelRun;
            aModelRun = set(aModelRun, val);
            aModel.ModelRun = aModelRun;
        otherwise
            error([prop,' is not a valid ', class(aModel), 'property']);
    end;     
end;

return;

