function display(aModel)
%  display function for Model class
%**************************************************************************
%
% $Id: display.m,v 1.1 2004/11/04 20:13:48 bhendrik Exp $
% $Revision: 1.1 $
% $Author: bhendrik $
% $Date: 2004/11/04 20:13:48 $
% Type: Matlab script.
%
% Comments: 
%
% Written by Bart Hendriks
%
%**************************************************************************

fprintf('\n [%g x %g] Model Object\n\n\n', size(aModel,1), size(aModel,2));

for i=1:size(aModel,2)
    
    Name = get(aModel(i), 'Name');
    NumberOfSpecies = size(get(aModel(i), 'Species'),2);
    NumberOfParameters = size(get(aModel(i), 'Parameter'),2);
    NumberOfReactions = size(get(aModel(i), 'Reaction'),2);
    NumberOfCompartments = size(get(aModel(i), 'Compartment'),2);
    NumberOfRuns = size(get(aModel(i), 'ModelRun'),2);
    ODEfilename = get(aModel(i), 'ODEfilename');
    
    fprintf('Model(%g)\n', i);
    fprintf('+----------------------------+\n     %s\n%10g Species\n%10g Parameters\n%10g Reactions\n%10g Compartments\n\n%10g Model Runs\n ODE file: %s\n+----------------------------+\n\n', ...
        Name, NumberOfSpecies, NumberOfParameters, NumberOfReactions, NumberOfCompartments, NumberOfRuns, ODEfilename);
    
    
    
    
end;

fprintf('\n');


return;