function WriteInputFiles(aModel)
% 
%**************************************************************************
%
% $Id: WriteInputFiles.m,v 1.1 2004/11/04 20:13:47 bhendrik Exp $
% $Revision: 1.1 $
% $Author: bhendrik $
% $Date: 2004/11/04 20:13:47 $
% Type: Matlab script.
%
% Comments: This function writes two text files: (1) the Species initial
% conditions and (2) the Parameter values. These files are templates for
% easily manipulating ICs and parameter sets. 
%
% Written by Bart Hendriks
%
%**************************************************************************

ICfilename = cat(2, aModel.Name, '_IC.m');
PVfilename = cat(2, aModel.Name, '_PV.m');

IC = aModel.Species;
PV = aModel.Parameter;


fid = fopen(ICfilename,'w');
for i=1:size(IC,2)
    fprintf(fid, '%%Species(%g).Name = ''%s''; Species(%g).Units = ''%s'';\n', IC(i).Number, IC(i).Name, IC(i).Number, IC(i).Units);
    fprintf(fid, 'Species(%g).IC = %g;\n\n', IC(i).Number, IC(i).IC);    
end;
fclose(fid);


fid = fopen(PVfilename,'w');
for i=1:size(PV,2)
    fprintf(fid, '%%Parameter(%g).Name = ''%s''; Parameter(%g).Units = ''%s'';\n', PV(i).Number, PV(i).Name, PV(i).Number, PV(i).Units);
    fprintf(fid, 'Parameter(%g).Value = %g;\n\n', PV(i).Number, PV(i).Value);    
end;
fclose(fid);

return;











return;