function aModel = SolveModel(aModel, RunNumber, tspan)
% 
%**************************************************************************
%
% $Id: SolveModel.m,v 1.1 2004/11/04 20:13:47 bhendrik Exp $
% $Revision: 1.1 $
% $Author: bhendrik $
% $Date: 2004/11/04 20:13:47 $
% Type: Matlab script.
%
% Comments: This function writes two text files: (1) the Species initial
% conditions and (2) the Parameter values. These files are templates for
% easily manipulating ICs and parameter sets. 
%
% Written by Bart Hendriks
%
%**************************************************************************
%
% This function takes a Model with an initialized ModelRun as input (that is, one with 
% initial conditions and parameter values)
%
% tspan is usually listed in seconds (although it really depends on how you
% have defined the units of your Parameter values).

if isempty(aModel.ModelRun(RunNumber).SpeciesIC) | ...
        isempty(aModel.ModelRun(RunNumber).ParameterValues) | ...
        isempty(aModel.ModelRun(RunNumber).CompartmentVolumes)
    error('ModelRun is not properly intialized')
end;

IC = aModel.ModelRun(RunNumber).SpeciesIC;
PV = aModel.ModelRun(RunNumber).ParameterValues;
CV = aModel.ModelRun(RunNumber).CompartmentVolumes;
ODEfilename = aModel.ODEfilename;
if strcmp(ODEfilename(end-1:end), '.m')
    ODEfilename = ODEfilename(1:end-2);
end;

if size(aModel.Species,2) == size(IC,2) & ...
        size(aModel.Parameter,2) == size(PV,2) & ...
        size(aModel.Compartment,2) == size(CV,2)
    
    options = odeset('AbsTol', 1e-10, 'RelTol', 1e-3);  
    fprintf('\nSOLVING MODEL ... run: ''%s''\n', aModel.ModelRun(RunNumber).Name);
    [t,Results] = ode15s(ODEfilename, tspan, IC, options, PV, CV);
else
    error('Number of Species, Parameters and/or Compartments does not match ModelRun initialization.');
end;

aModel.ModelRun(RunNumber).time = t;
aModel.ModelRun(RunNumber).Results = Results;


return;