function aModel = SSReceptorGuesses(aModel, RunNumber)
% 
%**************************************************************************
%
% $Id: SSReceptorGuesses.m,v 1.2 2004/11/09 21:10:45 bhendrik Exp $
% $Revision: 1.2 $
% $Author: bhendrik $
% $Date: 2004/11/09 21:10:45 $
% Type: Matlab script.
%
% Comments: This function writes two text files: (1) the Species initial
% conditions and (2) the Parameter values. These files are templates for
% easily manipulating ICs and parameter sets. 
%
% Written by Bart Hendriks
%
%**************************************************************************
%
% This function makes guesses at the steady state receptor levels based
% upon the receptor synthesis rates.

warning off;

PM_Vol_over_EM_Vol = aModel.Compartment(GPN(aModel.Compartment, 'Plasma Membrane')).Size/aModel.Compartment(GPN(aModel.Compartment, 'Endosomal Membrane')).Size;
    
if GPN(aModel.Species, 'ErbB1-----_PM') ~= 0
    % this little bit gives the model a head start for getting to
    % steady state.
    
    keR1 = aModel.Parameter(GPN(aModel.Parameter, 'keR1')).Value;
    kxR1 = aModel.Parameter(GPN(aModel.Parameter, 'kxR1')).Value;
    kdR1 = aModel.Parameter(GPN(aModel.Parameter, 'kdR1')).Value;

    ksyn_R1 = aModel.ModelRun(RunNumber).ParameterValues(GPN(aModel.Parameter, 'ksyn_R1'));
    Rs = (kxR1+kdR1)/keR1*ksyn_R1/kdR1;
    Ri = ksyn_R1/kdR1*PM_Vol_over_EM_Vol;
    aModel.ModelRun(RunNumber).SpeciesIC(GPN(aModel.Species, 'ErbB1-----_PM')) = Rs;
    aModel.ModelRun(RunNumber).SpeciesIC(GPN(aModel.Species, 'ErbB1-----_EN')) = Ri;
    aModel.ModelRun(RunNumber).SpeciesIC(GPN(aModel.Species, 'Total_ErbB1')) = Rs + Ri/PM_Vol_over_EM_Vol;

end;

if GPN(aModel.Species, 'ErbB2-----_PM') ~= 0

    keR2 = aModel.Parameter(GPN(aModel.Parameter, 'keR2')).Value;
    kxR2 = aModel.Parameter(GPN(aModel.Parameter, 'kxR2')).Value;
    kdR2 = aModel.Parameter(GPN(aModel.Parameter, 'kdR2')).Value;

    ksyn_R2 = aModel.ModelRun(RunNumber).ParameterValues(GPN(aModel.Parameter, 'ksyn_R2'));
    Rs = (kxR2+kdR2)/keR2*ksyn_R2/kdR2;
    Ri = ksyn_R2/kdR2*PM_Vol_over_EM_Vol;
    aModel.ModelRun(RunNumber).SpeciesIC(GPN(aModel.Species, 'ErbB2-----_PM')) = Rs;
    aModel.ModelRun(RunNumber).SpeciesIC(GPN(aModel.Species, 'ErbB2-----_EN')) = Ri;
    aModel.ModelRun(RunNumber).SpeciesIC(GPN(aModel.Species, 'Total_ErbB2')) = Rs + Ri/PM_Vol_over_EM_Vol;

end;

if GPN(aModel.Species, 'ErbB3-----_PM') ~= 0
    % this little bit gives the model a head start for getting to
    % steady state.
    keR3 = aModel.Parameter(GPN(aModel.Parameter, 'keR3')).Value;
    kxR3 = aModel.Parameter(GPN(aModel.Parameter, 'kxR3')).Value;
    kdR3 = aModel.Parameter(GPN(aModel.Parameter, 'kdR3')).Value;
    
    ksyn_R3 = aModel.ModelRun(RunNumber).ParameterValues(GPN(aModel.Parameter, 'ksyn_R3'));
    Rs = (kxR3+kdR3)/keR3*ksyn_R3/kdR3;
    Ri = ksyn_R3/kdR3*PM_Vol_over_EM_Vol;
    aModel.ModelRun(RunNumber).SpeciesIC(GPN(aModel.Species, 'ErbB3-----_PM')) = Rs;
    aModel.ModelRun(RunNumber).SpeciesIC(GPN(aModel.Species, 'ErbB3-----_EN')) = Ri;
    aModel.ModelRun(RunNumber).SpeciesIC(GPN(aModel.Species, 'Total_ErbB3')) = Rs + Ri/PM_Vol_over_EM_Vol;

end;

if GPN(aModel.Species, 'ErbB4-----_PM') ~= 0
    % this little bit gives the model a head start for getting to
    % steady state.
    keR4 = aModel.Parameter(GPN(aModel.Parameter, 'keR4')).Value;
    kxR4 = aModel.Parameter(GPN(aModel.Parameter, 'kxR4')).Value;
    kdR4 = aModel.Parameter(GPN(aModel.Parameter, 'kdR4')).Value;

    ksyn_R4 = aModel.ModelRun(RunNumber).ParameterValues(GPN(aModel.Parameter, 'ksyn_R4'));
    Rs = (kxR4+kdR4)/keR4*ksyn_R4/kdR4;
    Ri = ksyn_R4/kdR4*PM_Vol_over_EM_Vol;
    aModel.ModelRun(RunNumber).SpeciesIC(GPN(aModel.Species, 'ErbB4-----_PM')) = Rs;
    aModel.ModelRun(RunNumber).SpeciesIC(GPN(aModel.Species, 'ErbB4-----_EN')) = Ri;
    aModel.ModelRun(RunNumber).SpeciesIC(GPN(aModel.Species, 'Total_ErbB4')) = Rs + Ri/PM_Vol_over_EM_Vol;

end;

if GPN(aModel.Species, 'ErbBm-----_PM') ~= 0
    % this little bit gives the model a head start for getting to
    % steady state.
    keR1m = aModel.Parameter(GPN(aModel.Parameter, 'keR1m')).Value;
    kxR1m = aModel.Parameter(GPN(aModel.Parameter, 'kxR1m')).Value;
    kdR1m = aModel.Parameter(GPN(aModel.Parameter, 'kdR1m')).Value;

    ksyn_R1m = aModel.ModelRun(RunNumber).ParameterValues(GPN(aModel.Parameter, 'ksyn_R1m'));
    Rs = (kxR1m+kdR1m)/keR1m*ksyn_R1m/kdR1m;
    Ri = ksyn_R1m/kdR1m*PM_Vol_over_EM_Vol;
    aModel.ModelRun(RunNumber).SpeciesIC(GPN(aModel.Species, 'ErbBm-----_PM')) = Rs;
    aModel.ModelRun(RunNumber).SpeciesIC(GPN(aModel.Species, 'ErbBm-----_EN')) = Ri;
    aModel.ModelRun(RunNumber).SpeciesIC(GPN(aModel.Species, 'Total_ErbB1m')) = Rs + Ri/PM_Vol_over_EM_Vol;

end;

warning on;

return;