function aModel = Model(varargin)
% Model class constructor
%**************************************************************************
%
% $Id: Model.m,v 1.1 2004/11/04 20:13:46 bhendrik Exp $
% $Revision: 1.1 $
% $Author: bhendrik $
% $Date: 2004/11/04 20:13:46 $
% Type: Matlab script.
%
% Comments: 
%
% Written by Bart Hendriks
%
%**************************************************************************


switch nargin
    case 0  
        structModel= struct('Name', {}, ...
            'Species', Species , ...
            'Parameter', Parameter , ...
            'Reaction', Reaction , ...
            'Compartment', Compartment , ...
            'ODEfilename', {}, ...
            'ModelRun', ModelRun, ...
            'ConversionFactor', ConversionFactor ...
             );
        structModel(1).Name = 'Empty Model';  
        aModel = class(structModel,'Model');
        aModel.Species = Species;
        aModel.Parameter = Parameter;
        aModel.Reaction = Reaction;
        aModel.Compartment = Compartment;
        aModel.ModelRun = ModelRun;
        aModel.ConversionFactor = ConversionFactor;
    case 1  
        if isa(varargin{1},'Model')
            aModel = varargin{1};
        end;
    case 5
        aModel = Model;
        ModelName = varargin{1}; % Name of the model
        S = varargin{2}; % Species
        P = varargin{3}; % Parameters
        R = varargin{4}; % Reactions
        C = varargin{5}; % Compartments
        aModel = set(aModel, ...
            'Name', ModelName, ...
            'Species', S,  ...
            'Parameter', P, ...
            'Reaction', R, ...
            'Compartment', C ...
            );    
        
        
        % generate odefile
            
    case 8
        aModel = Model;
        ModelName = varargin{1}; % Name of the model
        S = varargin{2}; % Species
        P = varargin{3}; % Parameters
        R = varargin{4}; % Reactions
        C = varargin{5}; % Compartments
        ConstantSpecies = varargin{6}; % Species that are constant
        CompoundSpecies = varargin{7}; % Compound Species
        CellsPerLiter = varargin{8}; % Cells per Liter
        CF = ConversionFactor;
        CF = set(CF, 'CPL', CellsPerLiter);
        
        aModel = set(aModel, ...
            'Name', ModelName, ...
            'Species', S,  ...
            'Parameter', P, ...
            'Reaction', R, ...
            'Compartment', C, ... 
            'ConstantSpecies', ConstantSpecies, ...
            'CompoundSpecies', CompoundSpecies, ...
            'ConversionFactor', CF ...
            ); 
        
        % calculate conversion factors ...
        Nav = 6.022e23;
        % Plasma membrane conversion factor: [#/L]/nM
        warning off;
        PM_Index = GPN(aModel.Compartment, 'Plasma Membrane');
        EM_Index = GPN(aModel.Compartment, 'Endosomal Membrane');
        CY_Index = GPN(aModel.Compartment, 'Cytoplasm');
        NU_Index = GPN(aModel.Compartment, 'Nucleus');
        warning on;
        if PM_Index ~= 0
            PMCF = Nav*1e-9*get(aModel.Compartment(PM_Index), 'Size');
        else
            PMCF = 0;
        end;
        if EM_Index ~= 0
            EMCF = Nav*1e-9*get(aModel.Compartment(EM_Index), 'Size');
        else
            EMCF = 0;
        end;
        if CY_Index ~= 0
            CYCF = Nav*1e-9*get(aModel.Compartment(CY_Index), 'Size');
        else
            CYCF = 0;
        end;
        if NU_Index ~= 0
            NUCF = Nav*1e-9*get(aModel.Compartment(NU_Index), 'Size');
        else
            NUCF = 0;
        end;
        CF = set(CF, 'PMCF', PMCF, ...
            'EMCF', EMCF, ...
            'CYCF', CYCF, ...
            'NUCF', NUCF ...
            );
                
        aModel = set(aModel, 'ConversionFactor', CF);
        
        
        
    otherwise   
        error('Cannot initialize');
end;

return;

