function Model1 = MergeModels(Model1, Model2, Name)
%**************************************************************************
%
% $Id: MergeModels.m,v 1.2 2004/11/09 20:09:08 bhendrik Exp $
% $Revision: 1.2 $
% $Author: bhendrik $
% $Date: 2004/11/09 20:09:08 $
% Type: Matlab script.
%
% Comments: This function glues to Model objects together by simply
% sticking Model2 on the end of Model1. It does remove species with
% identical names from the second Model. It does NOT do any error checking
% or checking for duplicate entries! 
%
% Written by Bart Hendriks
%
%**************************************************************************

% Check to make sure the compartments are the same!!
if size(Model1.Compartment,2) ~= size(Model2.Compartment,2)
    error('Model Compartments must be identical to merge models');
end;

for i=1:size(Model1.Compartment,2)
    if ~strcmp(Model1.Compartment(i).Name, Model2.Compartment(i).Name) 
        error('Model Compartments must be identical to merge models');
    end;
    
    if(floor(Model1.Compartment(i).Size*1e3) ~= floor(Model2.Compartment(i).Size*1e3))
        disp('Yuk');
        disp(i);
        error('!!');
    end;
end;



NumberOfModel1Species = size(Model1.Species,2);
NumberOfModel2Species = size(Model2.Species,2);

NumberOfModel1Parameters = size(Model1.Parameter,2);
NumberOfModel1Reactions = size(Model1.Reaction,2);
NumberOfModel1Compartments = size(Model1.Compartment,2);



% Need to check for the case where a species is defined in both the
% trafficking and signaling models (this is likely to come up for species
% that are the interface between trafficking and signaling). This bit
% compiles a list of the species numbers that are duplicates (based on
% .Name field only!) so that they can be skipped over later.
IdenticalSpecies = [];
for i=1:NumberOfModel1Species
    for j=1:NumberOfModel2Species;
        if strcmp(Model1.Species(i).Name, Model2.Species(j).Name)
            IdenticalSpecies = cat(2, IdenticalSpecies, j);
            fprintf('Species %g, ''%s'' from the signaling model is a duplicate\n', j, Model2.Species(j).Name);
            fprintf('of a species in the trafficking model. The copy in the signaling model \nis being discarded. Double check to make sure you are okay with this!\n\n');
        end;
    end;    
end;



k = 0;
for i=1:size(Model2.Species,2)
    if isempty(find(IdenticalSpecies == i))
        % only add a species to the list if it is not in IdenticalSpecies 
        % (it does not duplicate a species already in the trafficking
        % model)
        k=k+1;
        Model1.Species(NumberOfModel1Species+k) = Model2.Species(i);
        Model1.Species(NumberOfModel1Species+k).Number = NumberOfModel1Species+k;  
    end; 
end;



for i=1:size(Model2.Parameter,2)
    Model1.Parameter(NumberOfModel1Parameters+i) = Model2.Parameter(i);
    Model1.Parameter(NumberOfModel1Parameters+i).Number = NumberOfModel1Parameters+i;  
end;

for i=1:size(Model2.Reaction,2)
    Model1.Reaction(NumberOfModel1Reactions+i) = Model2.Reaction(i);
    Model1.Reaction(NumberOfModel1Reactions+i).Number = NumberOfModel1Reactions+i;  
end;

Model1.Name = Name;



return;