function List(M, Field, filename, varargin)
% 
%**************************************************************************
%
% $Id: List.m,v 1.2 2004/11/16 21:19:28 bhendrik Exp $
% $Revision: 1.2 $
% $Author: bhendrik $
% $Date: 2004/11/16 21:19:28 $
% Type: Matlab script.
%
% Comments: This function writes a field of the model into a text file 
% which can be used for translation into SBML
%
% Written by Bart Hendriks
%
%**************************************************************************
%
% Allowable syntax:
% List(M, Field, filename)
% List(M, Field, filename, RunNumber)
% List(M, Field, filename, RunNumber, Writefile)
%
% - where M is a 'Model' object. 
% - Field is a string with the desired field name ('Species', for example). 
% - filename is the the name of the file to be written ('Modelfile_Parameters.txt', for example).
% - RunNumber is the ModelRun from which to pull the Species IC or Parameter Value
% - Writefile - if set to 0 then it will dump the output to the screen
% instead of writing a file.
%
% Allowable values for Field: 'Species', 'Parameter', 'Reaction', 
% 'Compartment', 'ConstantSpecies' or 'CompoundSpecies'.


if nargin > 3
    if ~isempty(varargin{1}) 
        RunNumber = varargin{1};
    end;
else
    RunNumber = 0;
end;

if nargin > 4
    if ~isempty(varargin{2})
        WriteFile = varargin{2};
    end;
else
    WriteFile = 1;
end;



if WriteFile == 1
    fid = fopen(filename,'w');
else
    fid = 1;
end;



if strcmp(Field, 'Parameter')
    for i=1:size(M.Parameter,2)
        fprintf(fid, 'Parameter_name = ''%s'';\n', M.Parameter(i).Name);
        fprintf(fid, 'Number = %g;\n', i);
        if RunNumber == 0 | (i>size(M.ModelRun(1).ParameterValues,2))
            % SBML_reformatting adds compartment volumes as extra
            % parameters ... so the number of parameter values in a model
            % run is now less than the number of parameters.
            fprintf(fid, 'Value = %g;\n', M.Parameter(i).Value);
        else
            fprintf(fid, 'Value = %g;\n', M.ModelRun(RunNumber).ParameterValues(i));
        end;
        fprintf(fid, 'Units = ''%s'';\n', M.Parameter(i).Units);
        fprintf(fid, 'End\n\n');
    end;
end;

if strcmp(Field, 'Species')
    for i=1:size(M.Species,2)
        fprintf(fid, 'Species_name = ''%s'';\n', M.Species(i).Name);
        fprintf(fid, 'Number = %g;\n', i);
        fprintf(fid, 'Location = ''%s'';\n', M.Species(i).Location);
        fprintf(fid, 'Boundary = %g;\n', M.Species(i).Boundary);
        if RunNumber == 0
            fprintf(fid, 'IC = %g;\n', M.Species(i).IC);
        else
            fprintf(fid, 'IC = %g;\n', M.ModelRun(RunNumber).SpeciesIC(i));
        end;
        fprintf(fid, 'Units = ''%s'';\n', M.Species(i).Units);
        fprintf(fid, 'End\n\n');
    end;
end;

RxnNumber = 0;
if strcmp(Field, 'Reaction')
    for i=1:size(M.Reaction,2)
        if ~isempty(M.Reaction(i).Flux) & ~isnan(M.Reaction(i).Flux)  % this removes any empty reactions in the list.
            RxnNumber = RxnNumber + 1;
            %fprintf(fid, 'Reaction_name = ''%s'';\n', List(i).Name);
            fprintf(fid, 'Reaction_name = ''Rxn'';\n');
            fprintf(fid, 'Number = %g;\n', RxnNumber);
            if ~isempty(M.Reaction(i).Reactant_1) & ~isnan(M.Reaction(i).Reactant_1)
                fprintf(fid, 'Reactant_1 = ''%s'';\n',M.Reaction(i).Reactant_1);   
            end;
            if ~isempty(M.Reaction(i).Reactant_2) & ~isnan(M.Reaction(i).Reactant_2)
                fprintf(fid, 'Reactant_2 = ''%s'';\n', M.Reaction(i).Reactant_2);   
            end;
            if ~isempty(M.Reaction(i).Product_1) & ~isnan(M.Reaction(i).Product_1)
                fprintf(fid, 'Product_1 = ''%s'';\n', M.Reaction(i).Product_1);   
            end;
            if ~isempty(M.Reaction(i).Product_2) & ~isnan(M.Reaction(i).Product_2)
                fprintf(fid, 'Product_2 = ''%s'';\n', M.Reaction(i).Product_2);   
            end;
            if ~isempty(M.Reaction(i).Modifier_1) & ~isnan(M.Reaction(i).Modifier_1)
                fprintf(fid, 'Modifier_1 = ''%s'';\n', M.Reaction(i).Modifier_1);   
            end;
            if ~isempty(M.Reaction(i).Modifier_2) & ~isnan(M.Reaction(i).Modifier_2)
                fprintf(fid, 'Modifier_2 = ''%s'';\n', M.Reaction(i).Modifier_2);   
            end;
            if ~isempty(M.Reaction(i).Modifier_3) & ~isnan(M.Reaction(i).Modifier_3)
                fprintf(fid, 'Modifier_3 = ''%s'';\n', M.Reaction(i).Modifier_3);   
            end;
            if ~isempty(M.Reaction(i).Parameter_1) & ~isnan(M.Reaction(i).Parameter_1)
                fprintf(fid, 'Parameter_1 = ''%s'';\n', M.Reaction(i).Parameter_1);   
            end;
            if ~isempty(M.Reaction(i).Parameter_2) & ~isnan(M.Reaction(i).Parameter_2)
                fprintf(fid, 'Parameter_2 = ''%s'';\n', M.Reaction(i).Parameter_2);   
            end;
            if ~isempty(M.Reaction(i).Parameter_3) & ~isnan(M.Reaction(i).Parameter_3)
                fprintf(fid, 'Parameter_3 = ''%s'';\n', M.Reaction(i).Parameter_3);   
            end;
            if ~isempty(M.Reaction(i).Parameter_4) & ~isnan(M.Reaction(i).Parameter_4)
                fprintf(fid, 'Parameter_4 = ''%s'';\n', M.Reaction(i).Parameter_4);   
            end;
            if ~isempty(M.Reaction(i).Parameter_5) & ~isnan(M.Reaction(i).Parameter_5)
                fprintf(fid, 'Parameter_5 = ''%s'';\n', M.Reaction(i).Parameter_5);   
            end;
        
            
        
            fprintf(fid, 'Flux = ''%s'';\n', M.Reaction(i).Flux);   
            fprintf(fid, 'End\n\n');
            
        end;
    end;
end;
    

if strcmp(Field, 'Compartment')
    for i=1:size(M.Compartment,2)
        fprintf(fid, 'Compartment_name = ''%s'';\n', M.Compartment(i).Name);
        fprintf(fid, 'Number = %g;\n', i);
        fprintf(fid, 'Size = %g;\n', M.Compartment(i).Size);
        fprintf(fid, 'Units = ''%s'';\n', M.Compartment(i).Units);
        fprintf(fid, 'Outside = ''%s'';\n', M.Compartment(i).Outside);
        fprintf(fid, 'End\n\n');
    end;
end;

if strcmp(Field, 'ConstantSpecies')
    for i=1:size(M.Species,2)
        if M.Species(i).ConstantSpecies ~= 0
            fprintf(fid, 'Constant_Species_name = ''%s'';\n', M.Species(i).Name);
            fprintf(fid, 'End\n\n');
        end;
    end;
end;

if strcmp(Field, 'CompoundSpecies')
    for i=1:size(M.Species,2)
        if ~isempty(M.Species(i).SubSpecies)
            fprintf(fid, 'Compound_Species_name = ''%s'';\n', M.Species(i).Name);
            fprintf(fid, 'Number = %g;\n', i);
            for j=1:size(M.Species(i).SubSpecies,2)
                temp = cell2mat(M.Species(i).SubSpecies(j));
                fprintf(fid, 'SubSpecies(%g) = ''%s'';\n', j, temp);
                clear temp;
            end;
            fprintf(fid, 'End\n\n');
        end;
    end;
end;

if fid ~= 1
    fclose(fid);
end;


return;