function b = subsref(a,index)
%SUBSREF Define field name indexing for ConversionFactor objects
%**************************************************************************
%
% $Id: subsref.m,v 1.1 2004/11/04 20:13:44 bhendrik Exp $
% $Revision: 1.1 $
% $Author: bhendrik $
% $Date: 2004/11/04 20:13:44 $
% Type: Matlab script.
%
% Comments: 
%
% Written by Bart Hendriks
%
%**************************************************************************

switch index(1).type
    case '()'
        ObjectIndex = cell2mat(index(1).subs);
        if length(index) > 1
            switch index(2).type
                case '.'
                    switch index(2).subs
                        case 'CPL'
                            b = a(ObjectIndex).CPL;
                        case 'PMCF'
                            b = a(ObjectIndex).PMCF;
                        case 'EMCF'
                            b = a(ObjectIndex).EMCF;
                        case 'CYCF'
                            b = a(ObjectIndex).CYCF;
                        case 'NUCF'
                            b = a(ObjectIndex).NUCF;
                        otherwise
                            error('Invalid field name')
                    end;
            end;
        else
            if isempty(ObjectIndex)
                b = a;
            else
                b = a(ObjectIndex);
            end;
        end;
    case '.'
        switch index(1).subs
            case 'CPL'
                b = a.CPL;
            case 'PMCF'
                b = a.PMCF;
            case 'EMCF'
                b = a.EMCF;
            case 'CYCF'
                b = a.CYCF;
            case 'NUCF'
                b = a.NUCF;
            otherwise
                error('Invalid field name')
        end;       
    case '{}'
        error('Cell array indexing not supported by ConversionFactor objects'); 
    otherwise
        b = a;
end;
                
return;