function a = subsasgn(a,index, val)
%SUBSASGN Define index assignment for ConversionFactor objects
%**************************************************************************
%
% $Id: subsasgn.m,v 1.1 2004/11/04 20:13:43 bhendrik Exp $
% $Revision: 1.1 $
% $Author: bhendrik $
% $Date: 2004/11/04 20:13:43 $
% Type: Matlab script.
%
% Comments: 
%
% Written by Bart Hendriks
%
%**************************************************************************

switch index(1).type
    case '()'
        ObjectIndex = cell2mat(index(1).subs);
        if length(index) > 1
            switch index(2).type
                case '.'
                    switch index(2).subs
                        case 'CPL'
                            a(ObjectIndex).CPL = val;
                        case 'PMCF'
                            a(ObjectIndex).PMCF = val;
                        case 'EMCF'
                            a(ObjectIndex).EMCF = val;
                        case 'CYCF'
                            a(ObjectIndex).CYCF = val;
                        case 'NUCF'
                            a(ObjectIndex).NUCF = val;
                        otherwise
                            error('Invalid field name')
                    end;
            end;
        else
            a(ObjectIndex) = val ;
        end;
    case '.'
        switch index(1).subs
            case 'CPL'
                a.CPL = val;
            case 'PMCF'
                a.PMCF = val;
            case 'EMCF'
                a.EMCF = val;
            case 'CYCF'
                a.CYCF = val;
            case 'NUCF'
                a.NUCF = val;
            otherwise
                error('Invalid field name')
        end;
    case '{}'
        error('Cell array indexing not supported by ConversionFactor objects') 
    otherwise
        a = val;
end;
                
return;