function aConversionFactor = set(aConversionFactor,varargin)
% ConversionFactor set
%**************************************************************************
%
% $Id: set.m,v 1.1 2004/11/04 20:13:43 bhendrik Exp $
% $Revision: 1.1 $
% $Author: bhendrik $
% $Date: 2004/11/04 20:13:43 $
% Type: Matlab script.
%
% Comments: 
%
% Written by Bart Hendriks
%
%**************************************************************************

property_argin = varargin;

if length(property_argin) == 1
    % in this case the input is a struct
    InputStruct = property_argin{1};
    if isa(InputStruct, 'ConversionFactor')
        aConversionFactor = set(aConversionFactor, 'CPL', InputStruct.CPL, ...
            'PMCF', InputStruct.PMCF, ...
            'EMCF', InputStruct.EMCF, ...
            'CYCF', InputStruct.CYCF, ...
            'NUCF', InputStruct.NUCF ...
            );
    end;
end;

while length(property_argin) >= 2,
    prop = property_argin{1};
    val = property_argin{2};
    property_argin = property_argin(3:end);
    switch prop
        case 'CPL'
            aConversionFactor.CPL = val ;
        case 'PMCF'
            aConversionFactor.PMCF = val ;
        case 'EMCF'
            aConversionFactor.EMCF = val ;
        case 'CYCF'
            aConversionFactor.CYCF = val ;
        case 'NUCF'
            aConversionFactor.NUCF = val ;
        otherwise
            error([prop,' is not a valid ', class(aSpecies), 'property']);
    end;     
end;

return;

