function aConversionFactor = ConversionFactor(varargin)
% ConversionFactor class constructor
%**************************************************************************
%
% $Id: ConversionFactor.m,v 1.1 2004/11/04 20:13:42 bhendrik Exp $
% $Revision: 1.1 $
% $Author: bhendrik $
% $Date: 2004/11/04 20:13:42 $
% Type: Matlab script.
%
% Comments: 
%
% Written by Bart Hendriks
%
%**************************************************************************
%
% CPL  : Cells per liter
% PMCF : Plasma Membrane compartment Conversion Factor (this converts nM in
% the plasma membrane compartment into #/liter).
% EMCF : Endosomal Membrane compartment Conversion Factor (this converts nM in
% the endosomal membrane compartment into #/liter).
% CYCF : CYtoplasm compartment Conversion Factor (this converts nM in
% the cytoplasm compartment into #/liter).
% NUCF : NUclear compartment Conversion Factor (this converts nM in
% the nuclear compartment into #/liter).

switch length(varargin)
    case 0  
        structConversionFactor= struct('CPL', {}, ...
            'PMCF', {}, ...
            'EMCF', {} , ...
            'CYCF', {} , ...
            'NUCF', {} ...
             );
        structConversionFactor(1).CPL = 0;  
        aConversionFactor = class(structConversionFactor, 'ConversionFactor');
    case 1  
        if isa(varargin{1},'ConversionFactor')
            aConversionFactor = varargin{1};
        elseif isa(varargin{1},'char')
            % not sure this comes up ...
        else
            error(['Argument to ConversionFactor is of class',class(varargin{1})]);
        end;
    otherwise   
        error('Cannot initialize');
end;

return;

