function b = subsref(a,index)
%SUBSREF Define field name indexing for Compartment objects
%**************************************************************************
%
% $Id: subsref.m,v 1.1 2004/11/04 20:13:41 bhendrik Exp $
% $Revision: 1.1 $
% $Author: bhendrik $
% $Date: 2004/11/04 20:13:41 $
% Type: Matlab script.
%
% Comments: 
%
% Written by Bart Hendriks
%
%**************************************************************************

switch index(1).type
    case '()'
        ObjectIndex = cell2mat(index(1).subs);
        if length(index) > 1
            switch index(2).type
                case '.'
                    switch index(2).subs
                        case 'Name'
                            b = a(ObjectIndex).Name;
                        case 'Number'
                            b = a(ObjectIndex).Number;
                        case 'Size'
                            b = a(ObjectIndex).Size;
                        case 'Units'
                            b = a(ObjectIndex).Units;
                        case 'Outside'
                            b = a(ObjectIndex).Outside;
                        otherwise
                            error('Invalid field name');
                    end;
            end;
        else
            if isempty(ObjectIndex)
                b = a;
            else
                b = a(ObjectIndex);
            end;
        end;
    case '.'
        error('Compartment.Fieldname syntax not supported by subsref.m');
    case '{}'
        error('Cell array indexing not supported by Compartment objects'); 
    otherwise
        b = a;
end;
                
return;