function aCompartment = set(aCompartment,varargin)
% Compartment set
%**************************************************************************
%
% $Id: set.m,v 1.1 2004/11/04 20:13:40 bhendrik Exp $
% $Revision: 1.1 $
% $Author: bhendrik $
% $Date: 2004/11/04 20:13:40 $
% Type: Matlab script.
%
% Comments: 
%
% Written by Bart Hendriks
%
%**************************************************************************

property_argin = varargin;

if length(property_argin) == 1
    % in this case the input is a struct
    InputStruct = property_argin{1};
    if isfield(InputStruct, 'Name')
        aCompartment.Name = InputStruct.Name ;
    end;
    if isfield(InputStruct, 'Number')
        aCompartment.Number = InputStruct.Number ;
    end;
    if isfield(InputStruct, 'Size')
        aCompartment.Size = InputStruct.Size ;
    end;
    if isfield(InputStruct, 'Units')
        aCompartment.Units = InputStruct.Units ;
    end;
    if isfield(InputStruct, 'Outside')
        aCompartment.Outside = InputStruct.Outside ;
    end;
    if isfield(InputStruct, 'Description')
        aCompartment.Description = InputStruct.Description ;
    end;
    if isfield(InputStruct, 'Reference')
        aCompartment.Reference = InputStruct.Reference ;
    end;
end;

while length(property_argin) >= 2,
    prop = property_argin{1};
    val = property_argin{2};
    property_argin = property_argin(3:end);
    switch prop
        case 'Name'
            aCompartment.Name = val ;
        case 'Number'
            aCompartment.Number = val ;
        case 'Value'
            aCompartment.Size = val ;
        case 'Units'
            aCompartment.Units = val ;
        case 'Outside'
            aCompartment.Outside = val ;
        case 'Description'
            aCompartment.Description = val ;
        case 'Reference'
            aCompartment.Reference = val ;
        otherwise
            error([prop,' is not a valid ', class(aCompartment), 'property']);
    end;     
end;

return;

